<?php
class UrbanoArg_Urbano_Block_Adminhtml_Enviosurbano_Grid extends Mage_Adminhtml_Block_Widget_Grid
{

    public function __construct()
    {
        parent::__construct();
        $this->setId('entity_id');
        $this->setDefaultSort('increment_id');
        $this->setDefaultDir('DESC');
        $this->setSaveParametersInSession(true);
        $this->setUseAjax(true);
    }

    protected function _prepareCollection()
    {
        $prefijo = (string) Mage::getConfig()->getTablePrefix();
        $collection = Mage::getModel('sales/order')->getCollection();
        $collection->getSelect()->join($prefijo.'sales_flat_shipment_track', 'main_table.entity_id = '.$prefijo.'sales_flat_shipment_track.order_id');
        $collection->addFieldToFilter('carrier_code',array('eq' => 'urbanoarg_urbano'));
        $this->setCollection($collection);
        parent::_prepareCollection();
        return $this;
    }

    protected function _prepareColumns()
    {
      $this->addColumn('store_name', array(
            'header' => Mage::helper('urbano')->__('Tienda'),
            'sortable' => true,
            'index' => 'store_name',
            'type'  => 'text'
        ));
      $this->addColumn('increment_id', array(
            'header' => Mage::helper('urbano')->__('# Orden'),
            'sortable' => true,
            'index' => 'increment_id',
            'type'  => 'text'
        ));
      $this->addColumn('customer_firstname', array(
            'header' => Mage::helper('urbano')->__('Nombre'),
            'sortable' => true,
            'index' => array('customer_firstname','customer_lastname'),
           'separator'    => ' ',
            'type'  => 'concat'
        ));
      $this->addColumn('customer_email', array(
            'header' => Mage::helper('urbano')->__('Email'),
            'sortable' => true,
            'index' => 'customer_email',
            'type'  => 'text'
        ));
      $this->addColumn('shipping_description', array(
            'header' => Mage::helper('urbano')->__('Tipo de Envio'),
            'sortable' => true,
            'index' => 'shipping_description',
            'type'  => 'text'
        ));
      $this->addColumn('total_item_count', array(
            'header' => Mage::helper('urbano')->__('Items'),
            'sortable' => true,
            'index' => 'total_item_count',
            'type'  => 'text'
        ));
        $this->addColumn('status', array(
            'header' => Mage::helper('urbano')->__('Estado'),
            'sortable' => true,
            'index' => 'status',
            'type'  => 'text'
        ));
      $this->addColumn('track_number', array(
            'header' => Mage::helper('urbano')->__('# Tracking'),
            'sortable' => true,
            'index' => 'track_number',
            'type'  => 'text'
        ));
      $this->addColumn('created_at', array(
            'header' => Mage::helper('urbano')->__('Fecha'),
            'sortable' => true,
            'index' => 'created_at',
            'type'  => 'datetime'
        ));
      
       $this->addExportType('*/*/exportCsv', Mage::helper('sales')->__('CSV'));
       $this->addExportType('*/*/exportExcel', Mage::helper('sales')->__('Excel XML'));
       
 
        return parent::_prepareColumns();
    }
	
}
?>