<?php
/**
 * @category    UrbanoArg
 * @package     UrbanoArg_Urbano
 * @copyright   Copyright (c) 2015 Urbano Argentina (http://www.urbano.com.ar)
 * @license     http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */
class UrbanoArg_Urbano_Model_Observer extends Mage_Core_Model_Session_Abstract {
	
  /**
   * Corre luego que se hace el checkout, siempre que este activado por back-office || run after checkout, in case it was activated from back-office
	 * @event: checkout_type_onepage_save_order
	 * @param $observer Varien_Event_Observer
	 */
	public function checkuotAfterObserver(Varien_Event_Observer $observer) {
      $config = Mage::getStoreConfig('carriers/urbanoarg_urbano');
      if (!$config['active'] || !$config['activeFrontSent'])
        return false;
      if($observer->getEvent()->getOrder()->getShippingMethod()!="urbanoarg_urbano_urbanoarg_urbano")
        return false;
      $order = Mage::getModel('sales/order')->load($observer->getEvent()->getOrder()->getId());
      $itemQty =  $order->getItemsCollection()->count();
      $shipment = Mage::getModel('sales/service_order', $order)->prepareShipment($itemQty);
      $shipmentApi = new Mage_Sales_Model_Order_Shipment_Api();
      $shipmentId = $shipmentApi->create( $order->getIncrementId(), array(), 'Enviado por Urbano', true, true);
    }

  /**
   * Corre al hacer click en el boton "SHIP" desde back-office | run on "SHIP" back-office button click
	 * @event: sales_order_shipment_save_before
	 * @param $observer Varien_Event_Observer
	 */
	public function salesOrderShipmentSaveBefore(Varien_Event_Observer $observer) {
      $config = Mage::getStoreConfig('carriers/urbanoarg_urbano');
      if (!$config['active'])
        return false;
      $shipment = $observer->getEvent()->getShipment();
      $order 	= $shipment->getOrder();
      if($order->getShippingMethod()!="urbanoarg_urbano_urbanoarg_urbano")
        return false;
      // Por si se llama varias veces al evento | in case the event be called more than 1 time
      $trackingNumbers = "";
      foreach ($shipment->getAllTracks() as $track)
        $trackingNumbers.= $track->getTrackNumber();
      if(!empty($trackingNumbers)){
        return false; 
      }
      $address      = $order->getShippingAddress();
      $nroEnvio     = $order->getIncrementId();
      //Arma Request | creation of Request
      $data = new stdClass();
      // Autentificacion
      $data->autentificacion->shipper = $config['shipUrb'];
      $data->autentificacion->password = $config['keyUrb'];
      // Destinatario
      $data->destinatario->tipoDocumento = '';
      $data->destinatario->numeroDocumento = '';
      $data->destinatario->nombre = $address->getName();
      $data->destinatario->email = $address->getEmail();
      $data->destinatario->telefono = $address->getTelephone();
      $data->destinatario->celular = '';
      // Autorizado 1
      $aut_1 = new stdClass();
      $aut_1->tipoDocumento = '';
      $aut_1->numeroDocumento = '';
      $aut_1->nombre = '';
      $aut_1->email = array();
      $aut_1->telefono = '';
      $aut_1->celular = '';
      // Autorizado 2
      $aut_2 = new stdClass();
      $aut_2->tipoDocumento = '';
      $aut_2->numeroDocumento = '';
      $aut_2->nombre = '';
      $aut_2->email = array('');
      $aut_2->telefono = '';
      $aut_2->celular = '';
      // Autorizado 3
      $aut_3 = new stdClass();
      $aut_3->tipoDocumento = '';
      $aut_3->numeroDocumento = '';
      $aut_3->nombre = '';
      $aut_3->email = array();
      $aut_3->telefono = '';
      $aut_3->celular = '';
      $data->autorizado = array($aut_1,$aut_2,$aut_3);
      // Domicilio
      $data->domicilio->direccion = $address->getData('street');
      $data->domicilio->altura = '';
      $data->domicilio->piso = '';
      $data->domicilio->departamento = '';
      $data->domicilio->codigoPostal = $address->getPostcode();
      $data->domicilio->localidad = '';
      $data->domicilio->provincia = $address->getCity();
      $data->domicilio->latitud   = '';
      $data->domicilio->longitud  = '';
      $data->domicilio->telefono = array();
      // Domicilio Alternativo
      $data->domicilioAlternativo->direccion = '';
      $data->domicilioAlternativo->altura = '';
      $data->domicilioAlternativo->piso = '';
      $data->domicilioAlternativo->departamento = '';
      $data->domicilioAlternativo->codigoPostal = '';
      $data->domicilioAlternativo->localidad = '';
      $data->domicilioAlternativo->provincia = '';
      $data->domicilioAlternativo->latitud   = '';
      $data->domicilioAlternativo->longitud  = '';
      $data->domicilioAlternativo->telefono = array();
      // Pieza
      // No se pueden sumar los valores de áreas
      $data->pieza->largo  = '';
      $data->pieza->alto   = '';
      $data->pieza->ancho  = '';
      $data->pieza->peso   = $order->getWeight();
      // General
      $data->datoNumerico = '';
      $data->codigoSeguimiento = $nroEnvio;
      $data->codigoAlternativo = '';
      $data->descripcionProducto = $nroEnvio;
      $data->valor = 0;
      $data->valorContrareembolso = 0;
      $data->modeloSms = $config['modeloSms']; // Traer del config
      $data->modeloEmail = $config['modeloEmail']; // Traer del config
      $data->cantidad = 1; // Pensado siempre como cross
      $data->sku = ''; // Si es warehousing, en caso de crossdocking va vacio
      $data->servicio = 'E'; // Entrega
      if (!empty($config['activeContraReembolso']) &&
            $order->getPayment()->getMethodInstance()->getCode()==$config['activeContraReembolso'])
        $data->servicio = 'B'; // ContraReembolso
      $data->marcaDeAgua = '';// Ver de pasar al config
      $data->remito = '';
      $data->observaciones = array('');
      try{
        $client = new SoapClient($config['gateway_url']."?wsdl", array('cache_wsdl' => WSDL_CACHE_NONE));
        $response = $client->cargaCliente($data);
        if ($response->codError!=0) {
          Mage::log("Error en envio por Urbano. Detalle: ");
          Mage::log("Request: ".  print_r($data,true));
          Mage::log("Response: ". print_r($response,true));
        } else {
          Mage::log("Envio por Urbano exitoso. Tracking: ".$nroEnvio);
          Mage::log("Request: ".  print_r($data,true));
          Mage::log("Response: ". print_r($response,true));
          $track = Mage::getModel('sales/order_shipment_track')
			    ->setNumber($nroEnvio)
			    ->setCarrierCode('urbanoarg_urbano') //carrier code
			    ->setTitle('Tracking ID');
          $shipment->addTrack($track);
        }
      } catch (Exception $e) { 
          Mage::log("Error en envio por Urbano. Detalle: ");
          Mage::log("Request: ".  print_r($data,true));
          Mage::log("Response: ".  print_r($response,true));
      }
	}
 
  /**
   * Envio masivo urbano
   * @param type $observer
   */
	public function envioMasivoUrbano($observer) {
        $block = $observer->getEvent()->getBlock();
        if(($block instanceof Mage_Adminhtml_Block_Widget_Grid_Massaction || $block instanceof Enterprise_SalesArchive_Block_Adminhtml_Sales_Order_Grid_Massaction)
            && $block->getRequest()->getControllerName() == 'sales_order')
        {
            $block->addItem('urbano', array(
                'label' => 'Generar pedido Urbano',
                'url' => $block->getUrl('urbano/adminhtml_orders/enviarurbano'),
                'confirm' => Mage::helper('sales')->__('Esta seguro de generar estos envios a Urbano?')
            ));
        }
    }

}
?>