<?php
namespace Urbano\Shipping\Controller\Adminhtml\Shipment;

use Magento\Backend\App\Action;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultInterface;

class ImprimirEtiqueta extends \Magento\Sales\Controller\Adminhtml\Order\AbstractMassAction
{
    /**
     * Authorization level of a basic admin session
     *
     * @see _isAllowed()
     */
    const ADMIN_RESOURCE = 'Magento_Sales::shipment';

    /** @var \Psr\Log\LoggerInterface */
    protected $_logger;

    /** @var \Urbano\Shipping\Helper\Config */
    protected $_config;

    /**
     * EndPoints de Urbano disponibles para consumo
     *
     * @var array
     */
    protected $endpoints;

    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Ui\Component\MassAction\Filter $filter
     * @param \Magento\Sales\Model\ResourceModel\Order\Shipment\CollectionFactory $collectionFactory
     * @param \Psr\Log\LoggerInterface $loggerInterface
     * @param \Urbano\Moduleshipping\Helper\Config $config
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Ui\Component\MassAction\Filter $filter,
        \Magento\Sales\Model\ResourceModel\Order\Shipment\CollectionFactory $collectionFactory,
        \Psr\Log\LoggerInterface $loggerInterface,
        \Urbano\Shipping\Helper\Urbano $urbano,
        \Urbano\Shipping\Helper\Config $config
    ) {
        $this->collectionFactory = $collectionFactory;
        $this->_logger = $loggerInterface;
        $this->_config = $config->getConfig();
        $this->endpoints = $urbano->getEndPoints();

        parent::__construct($context, $filter);
    }

    /**
     * Batch etiquetas Urbano.
     *
     * Obtiene el enlace para descargar el PDF de la etiqueta de envio.
     *
     * @param AbstractCollection $collection
     * @return ResponseInterface|ResultInterface
     */
    protected function massAction(\Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection $collection)
    {
        if (
            !$this->_config['active'] 
            || empty($this->_config['shipper']) 
            || empty($this->_config['key'])
            || empty($this->_config['tagsFormat'])
            ) {
            $this->getMessageManager()->addErrorMessage(
                __('No se ha realizado ningun cambio. Por favor revise la configuracion del modulo de Urbano.')
            );
            return $this->_redirect('sales/shipment/');
        }

        $labelsContent = [];

        if ($collection->getSize()) {
            
            /** @var \Magento\Sales\Model\Order\Shipment $shipment */
            foreach ($collection as $shipment) {
                foreach ($shipment->getTracks() as $track) {
                    if (($track->getCarrierCode() != "urbano_shipping" && $track->getCarrierCode() != "urbanoppc_shipping") || empty($track->getTrackNumber())) {
                        continue;
                    }

                    $params = http_build_query(array(
                        'tipo' => $this->_config['tagsFormat'],
                        'shipper' => $this->_config['shipper'],
                        'codSeguimiento' => $track->getTrackNumber()
                    ));

                    $labelsContent[] = [
                        "track" => "{$shipment->getIncrementId()}",
                        "order" => "{$track->getTrackNumber()}",
                        "url" => "{$this->_config['gateway']}{$this->endpoints['impresion_etiqueta']}?{$params}"
                    ];
                }
            }
        }

        if (!empty($labelsContent)) {
            $message = 'En cada uno de los siguientes enlaces podrá descargar la etiqueta correspondiente:<br>';
            foreach ($labelsContent as $label) {
                $message .= "Envío: {$label['track']} | Orden: {$label['order']} |
                <a href=\"{$label['url']}\" target=\"_blank\">Etiqueta Urbano</a><br>";
            }      
            $this->messageManager->addSuccess($message);        
            return $this->resultRedirectFactory->create()->setPath('sales/shipment/');
        }

        $this->messageManager->addErrorMessage(
            __('No hay etiquetas disponibles para los envios seleccionados.')
        );
        return $this->resultRedirectFactory->create()->setPath('sales/shipment/');
    }
}
