<?php

namespace Urbano\Shipping\Helper;

class Config extends \Magento\Framework\App\Helper\AbstractHelper
{
    /** @var \Magento\Framework\App\Config\ScopeConfigInterface */
    protected $_scopeConfig;

    /** @var \Psr\Log\LoggerInterface */
    protected $_logger;

    /**
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Psr\Log\LoggerInterface $logger
    ) {
        $this->_scopeConfig = $scopeConfig;
    }

    /**
     * Devuelve los valores de las opciones del backoffice de Urbano.
     *
     * @return array
     */
    public function getConfig(){
        return $this->_scopeConfig->getValue(
            'carriers/urbano_shipping',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }
}
