<?php

namespace Urbano\Shipping\Observer;

class SalesOrderShipmentAfter implements \Magento\Framework\Event\ObserverInterface
{
    /** @var \Magento\Sales\Model\Order\Shipment\TrackFactory */
    protected $_trackFactory;

    /** @var \Psr\Log\LoggerInterface */
    protected $_logger;

    /** @var \Magento\Framework\Message\ManagerInterface */
    protected $_messageManager;

    /** @var \Urbano\Shipping\Helper\Urbano */
    protected $_urbano;

    /** @var \Urbano\Shipping\Helper\Config */
    protected $_config;

    public function __construct(
        \Psr\Log\LoggerInterface $logger,
        \Urbano\Shipping\Helper\Urbano $urbano,
        \Urbano\Shipping\Helper\Config $config,
        \Magento\Sales\Model\Order\Shipment\TrackFactory $trackFactory
    ) {
        $this->_logger = $logger;
        $this->_config = $config->getConfig();
        $this->_urbano = $urbano;
        $this->_trackFactory = $trackFactory;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        if (
          !$this->_config['active']
          || empty($this->_config['shipper'])
          || empty($this->_config['key'])
          ) {
            return false;
        }

        $shipment = $observer->getEvent()->getShipment();
        
        /** @var \Magento\Sales\Model\Order */
        $order = $shipment->getOrder();
        
        if ($order->getShippingMethod() != "urbano_shipping_urbano_shipping") {
            return false;
        }

        $trackingNumbers = "";
        foreach ($shipment->getAllTracks() as $track) {
            $trackingNumbers .= $track->getTrackNumber();
        }
        if (!empty($trackingNumbers)) {
            return false;
        }

        $nroEnvio = $order->getIncrementId();

        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $_order = $objectManager->get('Magento\Sales\Model\Order');
        $order = $_order->loadByIncrementID($nroEnvio);

        $body = $this->_urbano->prepareBodyPostCargaClientes($order);
        $request = $this->_urbano->postCargaClientes($body);
        if ($request['success'] == "false") {
            $this->_logger->log(100, "return false");
            throw new \Magento\Framework\Exception\LocalizedException(
                __(
                    isset($request['descError'])
                    ? "Urbano error: {$request['descError']}"
                    : "Ocurrio un error al informar a Urbano de la orden..."
                    )
            );
        }

        $track = $this->_trackFactory->create()->addData([
          'carrier_code' => 'urbano_shipping',
          'title' => 'Tracking ID',
          'number' => $nroEnvio
        ]);

        $shipment->addTrack($track)->save();
    }
}
