<?php

namespace Urbanoppc\Shipping\Controller\Sucursal;

use Magento\Framework\App\Request\Http as HttpRequest;
/**
 * Class Index
 *
 * @description Recibe un codigo postal y devuelve las sucursales que tiene disponible
 *
 * @author Castelli Dario <dcastelli@urbano.com.ar>
 * @package Urbanoppc\Shipping\Controller\Sucursal
 */
class Index extends \Magento\Framework\App\Action\Action {

    /**
     * Authorization level of a basic admin session
     *
     * @see _isAllowed()
     */
    const ADMIN_RESOURCE = 'Magento_Sales::sales_order';

    /** @var \Magento\Sales\Model\ResourceModel\Order\CollectionFactory */
    protected $_orderCollectionFactory;

    /** @var \Psr\Log\LoggerInterface */
    protected $_logger;

    /** @var \Urbano\Shipping\Helper\Urbano */
    protected $_urbano;

    /** @var \Urbano\Shipping\Helper\Config */
    protected $_config;

    /**
     * @param \Urbano\Moduleshipping\Helper\Urbano $urbano
     * @param \Urbano\Shipping\Helper\Config $config
     * @param \Psr\Log\LoggerInterface $logger
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $orderCollectionFactory
     */
    public function __construct(
        \Urbano\Shipping\Helper\Urbano $urbano,
        \Urbano\Shipping\Helper\Config $config,
        \Psr\Log\LoggerInterface $logger,
        \Magento\Backend\App\Action\Context $context,
        \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $orderCollectionFactory
    ) {
        $this->_orderCollectionFactory = $orderCollectionFactory;
        $this->_logger = $logger;
        $this->_urbano = $urbano;
        $this->_config = $config->getConfig();

        parent::__construct($context);
    }
    public function execute()
    {
        
        $sucursales = $this->_urbano->getPickup();    
        return $sucursales;
        //print_r($sucursales);
        
    }
}