;define([
    'uiComponent',
    'ko',
    'Magento_Checkout/js/model/quote'

], function (Component, ko, quote) {
    'use strict';

    return Component.extend({
        defaults: {
            template: 'Urbanoppc_Shipping/additional-shipping-option'
        },

        initObservable: function () {
            var self = this._super();

            this.showAdditionalOption = ko.computed(function() {
                var method = quote.shippingMethod();

                if(method && method['carrier_code'] == "urbanoppc_shipping") {
                    
                    return true;
                }

                return false;

            }, this);

            return this;
        }
    });
});