# Modulo Urbano Express Argentina | Magento 2.3

# Plugin Version: 2.2.3.3

Copyright Copyright (c) 2025 [Urbano Express Argentina S.A.](https://www.urbano.com.ar)

License [Open Software License (OSL 3.0)](http://opensource.org/licenses/osl-3.0.php)

---

## Aclaraciones

Desde la versión 2.3 de Magento no se podrá instalar desde el asistente de instalación.
Una de las forma de poder instalar Magento a partir de esta versión es con Elasticsearch que a continuación se explicara paso por paso.

## Requisitos

Para el correcto funcionamiento del módulo es necesario contar con: Magento  >= v2.3.x

## Instalación

# Apache o Nginx (PHP ≥ 7.3)
# Composer
# Elasticsearch
# Magento (Version 2.4.1 sin sample data)

Cree una nueva carpeta dentro de htdocs con el nombre de " elasticsearch" . Pegue el archivo zip de Elasticsearch descargado dentro de la carpeta recién creada. Extraiga el archivo zip, navegue hasta la carpeta bin y haga doble clic en " elasticsearch.bat" para iniciar el clúster de elasticsearch.

Asegúrese de que elasticsearch esté en funcionamiento visitando localhost: 9200 en cualquier navegador. Debería ver un objeto JSON.

Ahora vaya a localhost / phpmyadmin y cree una nueva base de datos ' magento '

Crea una nueva carpeta dentro de htdocs con el nombre de ' magento '. Pegue el archivo zip de Magento, que descargamos anteriormente, dentro de esta carpeta y extráigalo.

Dentro de su directorio magento , vaya a vendor \ magento \ framework \ Image \ Adapter y abra G2d.php con cualquier editor de código. Busque el método llamado " validateURLScheme ", que debería estar en la línea # 86 . Reemplace todo el código del método con este código:
```
private function validateURLScheme(string $filename) : bool
{
   $allowed_schemes = ['ftp', 'ftps', 'http', 'https'];
   $url = parse_url($filename);
   if ($url && isset($url['scheme']) && !in_array($url['scheme'], $allowed_schemes) && !file_exists($filename)) 
    {
       return false;
     }
   return true;
}
```
Dentro de su directorio magento , navegue a vendor \ magento \ framework \ View \ Element \ Template \ File y abra Validator.php con cualquier editor de código. Desplácese hacia abajo hasta la línea # 138 . Reemplace toda la línea con el siguiente fragmento:
```
$realPath = str_replace('\\', '/',$this->fileDriver->getRealPath($path));
```
Dentro de su directorio magento , navegue a vendor \ magento \ framework \ Interception y abra PluginListGenerator.php con cualquier editor de código. Desplácese hacia abajo hasta la línea 158 . Reemplace toda la línea con el siguiente fragmento:
```
$cacheId = implode(‘-’, $this->scopePriorityScheme) . “-” . $this->cacheId;
```
Dentro de su directorio de instalación de XAMPP, vaya a xampp / php y abra php.ini con cualquier editor de código. Habilite las extensiones intl, soap, sockets, xsl en las líneas 921, 943, 944, 949 respectivamente eliminando el punto y coma antes de la extensión de la palabra. Ahora reinicie xampp.

Dentro de su directorio magento, abra cmd y ejecute los siguientes comandos en orden. Si algún comando da un error, asegúrese de que su versión de PHP sea 7.3 o superior y que haya realizado todos los cambios mencionados anteriormente.
```
php bin/magento setup:install --base-url=”http://localhost/magento" --db-host=”localhost” --db-name=”magento" --db-user=”root” --db-password=”” --admin-firstname=”admin” --admin-lastname=”admin” --admin-email=”user@example.com” --admin-user=”admin” --admin-password=”admin123" --use-rewrites=”1" --backend-frontname=”admin”

php bin/magento setup:di:compile

php bin/magento indexer:reindex

php bin/magento setup:upgrade

php bin/magento setup:static-content:deploy –f

php bin/magento deploy:mode:set developer

php bin/magento cache:clean

php bin/magento cache:flush

php bin/magento module:disable Magento_Csp

php bin/magento module:disable Magento_TwoFactorAuth
```

```
INSERT INTO `core_config_data`(`path`, `value`) VALUES (‘dev/static/sign’, 0) ON DUPLICATE KEY UPDATE `value`=0
```

Abra localhost / magento / admin en cualquier navegador e inicie sesión usando 'admin' y 'admin123' como nombre de usuario y contraseña respectivamente. Después de iniciar sesión, si el cargador no desaparece y sigue cargándose, hay un cambio más que debe realizar. Dentro de su directorio magento, navegue a la aplicación / etc / di.xml y busque

```Magento\Framework\App\View\Asset\MaterializationStrategy\Symlink```

y reemplazarlo con

```Magento\Framework\App\View\Asset\MaterializationStrategy\Copy```

Ahora actualice la página y listo, ¡ha instalado Magento 2.4 con éxito!

Para la instalación del modulo se debe descomprimir el modulo en la carpeta *app/code/*. Dentro de code, se deberá renombrar la carpeta a Urbano (respetando las mayúsculas y minúsculas).

De esa forma, la estructura de carpetas debe ser similar a la siguiente:

```
.
├── app
│   ├── code
│   │   ├── Magento
|   |   |   [...]
│   │   └── Urbano
│   │       └── Shipping
|   |
```

## Instalación

Se debe descomprimir el modulo en la carpeta *app/code/*. Dentro de code, se debera renombrar la carpeta a Urbano (respetando las mayusculas y minusculas).

De esa forma, la estructura de carpetas debe ser similar a la siguiente:

```
.
├── app
│   ├── code
│   │   ├── Magento
|   |   |   [...]
│   │   └── Urbano
│   │       └── Shipping
|   |
```

Para concretar la instalacion procedemos a activar el modulo en Magento desde la terminal con los siguientes comandos:

1. php bin/magento module:enable Urbano_Shipping --clear-static-content
1. php bin/magento setup:upgrade
1. rm -rf var/di var/view_preprocessed
1. php bin/magento setup:static-content:deploy



## Autores

Urbano Express Argentina
