<?php

namespace Urbano\Shipping\Helper;

use Magento\Framework\Controller\Result\JsonFactory;

class Urbano extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * Numero de Shipper
     *
     * @var int|string
     */
    protected $shipper;

    protected $_cart;

    /**
     * Clave de acceso del shipper
     *
     * @var string
     */
    protected $password;
    
    /**
     * Ruta base de API Urbano
     *
     * @var string
     */
    protected $base_url;

    /**
     * EndPoints disponibles para consumo
     *
     * @var array
     */
    protected $endpoints;

    /** @var \Urbano\Shipping\Helper\Config */
    protected $_config;

    /** @var \Urbanoppc\Shipping\Helper\Config */
    protected $_config2;

    /** @var \Magento\Framework\HTTP\ZendClientFactory */
    protected $_httpClient;

    /** @var \Psr\Log\LoggerInterface */
    protected $_logger;

    protected $_resultJsonFactory;

    protected $declarado_fijo;

    protected $declarado_porcentaje;

    /**
     * @param \Psr\Log\LoggerInterface $logger
     * @param \Magento\Framework\HTTP\ZendClientFactory $httpClient
     * @param \Urbano\Moduleshipping\Helper\Config $config
     * @param \Urbanoppc\Moduleshipping\Helper\Config $config2
     * @param JsonFactory $resultJsonFactory
     */

    public function __construct(
        \Psr\Log\LoggerInterface $logger,
        \Magento\Framework\HTTP\ZendClientFactory $httpClient,
        \Magento\Checkout\Model\Cart $cartModel,
        \Urbano\Shipping\Helper\Config $config,
        JsonFactory $resultJsonFactory,
        \Urbanoppc\Shipping\Helper\Config $config2


    ) {
        $this->_config = $config->getConfig();
        $this->_config2 = $config2->getConfig();

        $this->shipper = $this->_config['shipper'];
        $this->password = $this->_config['key'];
        $this->base_url = $this->_config['gateway'];
         $this->declarado_fijo = $this->_config['declarado_fijo'];
        $this->declarado_porcentaje = $this->_config['declarado_porcentaje'];
        $this->_cart = $cartModel;
        $this->endpoints = [
            "tarifa" => "/consulta_tarifa_rest/",
            "carga_clientes" => "/cargaCliente/",
            "tracking" => "/cespecifica/",
            "tracking_masivo" => "/tracking/consultaTrackingMasivo/",
            "pickup" => "puntosDeRetiroSucursales/",
            "impresion_etiqueta" => "impresionEtiqueta/"
        ];

        $this->_httpClient = $httpClient;
        $this->_logger = $logger;
        $this->_resultJsonFactory = $resultJsonFactory;
    }


    /**
     * Devuelve los EndPoints disponibles.
     *
     * @return array
     */
    public function getEndPoints()
    {
        return $this->endpoints;
    }

    /**
     * Tarifa de Urbano
     *
     * Obtiene mediante API la tarifa de Urbano de acuerdo al
     * codigo postal enviado.
     *
     * @param int|string $zipcode
     * @return array
     */
    public function postTarifa($zipcode)
    {
        try {
            $headers = [
              "Content-Type: application/json",
            ];
        
            // Traigo el carrito (assuming you have a separate function for this)
            $items = $this->_cart->getQuote()->getAllItems();
            $weight = 0;
        
            // Iterate to get weight
            foreach ($items as $item) {
              $weight += ($item->getWeight() * $item->getQty());
            }
        
            $params = [
              "codigoPostal" => $zipcode,
              "pesoEspecifico" => $weight,
              "pesoVolumetrico" => 0,
              "alto" => 0,
              "largo" => 0,
              "ancho" => 0,
              "autentificacion" => [
                "shipper" => $this->shipper,
                "password" => $this->password,
              ]
            ];
        
            $uri = "{$this->base_url}{$this->endpoints['tarifa']}";
        
            // Initialize cURL
            $ch = curl_init($uri);
        
            // Set cURL options
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
            // Send the request and get the response
            $response = curl_exec($ch);
            $requestBody = json_decode($response, true);
        
            // Check for errors
            $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            if ($responseCode != 200 || $requestBody['codError'] != 0) {
              $this->_logger->log(100, print_r($ch, true));
              curl_close($ch);
              return [
                "success" => "false",
                "code" => $responseCode,
              ] + $requestBody;
            }
        
            curl_close($ch);
        
            $response = [
              "success" => "true",
              "code" => $responseCode,
            ] + $requestBody;
        
            $this->_logger->log(100, print_r($params, true));
            return $response;
        
        } catch (\Exception $e) {
            return [
                "success" => false,
                "code" => $e->getCode(),
                "message" => $e->getMessage(),
            ];
        }
    }

    /**
     * Genera una nueva guia.
     *
     * Envia el/los productos a Urbano para generar una nueva guia.
     *
     * @param array $body
     * @return object
     */
    public function postCargaClientes($body)
    {
        try {
            $headers = [
            "Content-Type: application/json",
            ];

            $uri = "{$this->base_url}{$this->endpoints['carga_clientes']}";

            // Initialize cURL
            $ch = curl_init($uri);

            // Set cURL options
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($body));
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            // Send the request and get the response
            $response = curl_exec($ch);
            $requestBody = json_decode($response, true);

            // Check for errors
            $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            if ($responseCode != 200 || $requestBody['resultado'] == "error") {
            $this->_logger->log(100, print_r($ch, true));
            curl_close($ch);
            return [
                "success" => "false",
                "code" => $responseCode,
            ] + $requestBody;
            }

            curl_close($ch);

            $response = [
            "success" => "true",
            "code" => $responseCode,
            ] + $requestBody;

            $this->_logger->log(100, print_r($body, true));
            return $response;

        } catch (\Exception $e) {
            return [
            "success" => false,
            "code" => $e->getCode(),
            "message" => $e->getMessage(),
            ];
        }
    }


    public function tarifa_pickup($cp){
        $result = $this->_resultJsonFactory->create();

        try {
            
            $peso_ppc = 1;

            $params = '{
                "ubicacion": {
                    "va_prov_codigo": "%",
                    "va_con_llc": 1
                },
                "pieza": {
                    "peso": '.$peso_ppc.',
                    "alto": 0,
                    "largo": 0,
                    "ancho": 0
                },
                "autentificacion": {
                    "shipper": "'.$this->shipper.'",
                    "password": "'.$this->password.'"
                },
                "elockers" : 0
            }';
            $url = $this->base_url.'puntosDeRetiroSucursales/';

            $ch = curl_init($url);

            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
            $uea_response = curl_exec($ch);
            $sucursales = json_decode($uea_response, true);
            curl_close($ch);

            if(isset($sucursales[0]['data'])){
                $sucursales = $sucursales[0]['data'];
            }
            else{
                $sucursales = false;
            }

           $tarifa = 0;

            if($sucursales){
               
                for ($k=0; $k < count($sucursales); $k++) {
                    if ( $sucursales[$k]['codigoPostal'] ){
                        $tarifa = $sucursales[$k]['tarifa'] ? $sucursales[$k]['tarifa'] : 0;
                        break;
                    }
                }

            }

    
            return $tarifa;

        } catch (\Exception $e) {

            return "Sin sucursales";

        }
    }

    public function getPickup()
    {
        $result = $this->_resultJsonFactory->create();

        try {
            
            $peso_ppc = 1;

            $params = '{
                "ubicacion": {
                    "va_prov_codigo": "%",
                    "va_con_llc": 1
                },
                "pieza": {
                    "peso": '.$peso_ppc.',
                    "alto": 0,
                    "largo": 0,
                    "ancho": 0
                },
                "autentificacion": {
                    "shipper": "'.$this->shipper.'",
                    "password": "'.$this->password.'"
                },
                "elockers" : 0
            }';
            $url = $this->base_url.'puntosDeRetiroSucursales/';

            $ch = curl_init($url);

            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
            $uea_response = curl_exec($ch);
            $sucursales = json_decode($uea_response, true);
            curl_close($ch);

            if(isset($sucursales[0]['data'])){
                $sucursales = $sucursales[0]['data'];
            }
            else{
                $sucursales = false;
            }

           $arrayRate = array();

            if($sucursales){
               
                for ($k=0; $k < count($sucursales); $k++) {

                    $provincia = $sucursales[$k]['provincia'] ? $sucursales[$k]['provincia'] : $sucursales[$k]['municipalidad'];
                    if (!$provincia)
                        continue;

                    $direccion = $sucursales[$k]['prov_codigo'] . ' ' . $provincia . ' - ' . $sucursales[$k]['direccion'];
                    $cp = $direccion." - ".$sucursales[$k]['codigoPostal'];

                    $datos = [
                        'label' => $direccion,
                        'value' => $cp,
                    ];
                    array_push($arrayRate, $datos);//para agregar nuevo elemento al array  
                }
            }
            sort($arrayRate);

            //$arrayRate['0'] ="Sin sucursal";
    
            return $result->setData($arrayRate);

        } catch (\Exception $e) {

            return "Sin sucursales";

        }
    }

    public function postTracking($guias)
    {
        try {
            $headers = [
            "Content-Type: application/json",
            ];

            $body = [
            "autentificacion" => [
                "shipper" => $this->shipper,
                "password" => $this->password,
            ],
            "datos" => [],
            ];

            // Build the "datos" array
            foreach ($guias as $guia) {
            $body['datos'][] = [
                "codigoSeguimiento" => $guia['codigoSeguimiento'],
                "codigoAlternativo" => $guia['codigoAlternativo'],
            ];
            }

            $uri = "{$this->base_url}{$this->endpoints['tracking_masivo']}";

            // Initialize cURL
            $ch = curl_init($uri);

            // Set cURL options
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($body));
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            // Send the request and get the response
            $response = curl_exec($ch);
            $requestBody = json_decode($response, true);

            // Check for errors
            $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            if ($responseCode != 200 || $requestBody['resultado'] == "error") {
            $this->_logger->log(100, print_r($ch, true));
            curl_close($ch);
            return [
                "success" => "false",
                "code" => $responseCode,
            ] + $requestBody;
            }

            curl_close($ch);

            $response = [
            "success" => "true",
            "code" => $responseCode,
            ] + $requestBody;

            $this->_logger->log(100, print_r($body, true));
            return $response;

        } catch (\Exception $e) {
            return [
            "success" => false,
            "code" => $e->getCode(),
            "message" => $e->getMessage(),
            ];
        }
    }


    /**
     * Hace la peticion a la API Rest de Urbano
     *
     * @param string $url
     * @param string $method
     * @param object $jsonBody
     * @param array $headers
     * @return object
     */
    private function caller($url, $method, $jsonBody, $headers = [])
    {
        $options = [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
        ];

        if ($method == "POST") {
            $options[CURLOPT_POST] = true;
            $options[CURLOPT_POSTFIELDS] = json_encode($jsonBody);
        }

        if (!empty($headers)) {
            $options[CURLOPT_HTTPHEADER] = [];
            foreach ($headers as $key => $value) {
            $options[CURLOPT_HTTPHEADER][] = "$key: $value";
            }
        }

        $ch = curl_init();
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        curl_close($ch);

        // Assuming you want a decoded JSON response
        return json_decode($response, true);
    }


    /**
     * Prepara el cuerpo para la solicitud a CargaClientes de Urbano
     *
     * @param \Magento\Sales\Model\Order $order
     *
     * @return array
     */
    public function prepareBodyPostCargaClientes($order)
    {
       $address = $order->getShippingAddress();
       $total = $order->getExtensionAttributes();

        $observaciones = null;
        $servicio = "E";
        $uea_sd_shipper_id = null;
        $uea_sd_shipper_pass = null;
        $uea_sd_cod_poe = null;
        $shipper = $this->_config['shipper'];
        $pass = $this->_config['key'];

        if ($order->getShippingMethod() == "urbanoppc_shipping_urbanoppc_shipping"){
            $observaciones = "Pickup point";
            $servicio = "F";
            $shipper = $this->_config['shipper'];
            $pass = $this->_config['key'];
        }

        $addressStreet  = $address->getData('street');
        $street = str_replace("
", ", ", $addressStreet);

        $body = [
            'autentificacion' => [
                'shipper' => $shipper,
                'password' => $pass,
            ],
            'destinatario' => [
                'tipoDocumento' => '',
                'numeroDocumento' => '',
                'nombre' => $address->getName(),
                'email' => [
                    $address->getEmail(),
                ],
                'telefono' => $address->getTelephone(),
                'celular' => '',
            ],
            'autorizado' => [
                [
                    'tipoDocumento' => '',
                    'numeroDocumento' => '',
                    'nombre' => '',
                    'email' => [],
                    'telefono' => '',
                    'celular' => '',
                ],
            ],
            'domicilio' => [
                'direccion' => $street,
                'altura' => '',
                'piso' => '',
                'departamento' => '',
                'codigoPostal' => $address->getPostcode(),
                'localidad' => $address->getCity(),
                'provincia' => $address->getRegion(),
                'latitud' => '',
                'longitud' => '',
                'telefono' => [],
            ],
            'domicilioAlternativo' => [
                'direccion' => '',
                'altura' => '',
                'piso' => '',
                'departamento' => '',
                'codigoPostal' => '',
                'localidad' => '',
                'provincia' => '',
                'latitud' => '',
                'longitud' => '',
                'telefono' => [],
            ],
            'datoNumerico' => '',
            'codigoSeguimiento' => $order->getIncrementId(),
            'codigoAlternativo' => '',
            'modeloSms' => $this->_config['modeloSms'],
            'modeloEmail' => $this->_config['modeloEmail'],
            'servicio' => $servicio, // Entrega
            'marcaDeAgua' => '',
            'remito' => '',
            'observaciones' => [],
        ];

        $this->_logger->log(100, "puntos pickup points: ".print_r($total, true));

        if (
            !empty($this->_config['activeContraReembolso']) &&
            $order->getPayment()->getMethod() == $this->_config['activeContraReembolso']
        ) {
            $body['servicio'] = 'B';
        }else{
            $body['servicio'] = 'E';
        }

        $body['productos'] = $this->addProductsToPostBody($order, $body['servicio']);

        if ($servicio == "F")
            $body['servicio'] = 'F';

        return $body;
    }


    /**
     * Cree en contenido de Productos para la solicitud a Urbano.
     *
     * @param \Magento\Sales\Model\Order $order
     * @param string $servicio
     *
     * @return array
     */
    protected function addProductsToPostBody($order, $servicio)
    {
        $productos = [];

        if (isset($this->declarado_fijo) && $this->declarado_fijo > 0)
            $declarado_fijo = $this->declarado_fijo;
        else
            $declarado_fijo = 0;

        switch ($servicio) {
            case 'E':
                /** @var \Magento\Sales\Model\Order\Item $orderItem */
                
                foreach ($order->getAllItems() as $orderItem) {
                   
                    if (!$orderItem->getQtyToShip() || $orderItem->getIsVirtual()) {
                        continue;
                    }

                    $peso = 0;
                    $cantidad = $orderItem->getQtyOrdered();
                    $totalPrecio = $orderItem->getPrice() * $cantidad;

                    if ($this->declarado_porcentaje>0)
                        $declarado = ( $this->declarado_porcentaje * $totalPrecio ) / 100;
                    else
                        $declarado = $declarado_fijo;

                    $peso += $orderItem->getWeight();

                    if ($this->_config['modoEnvio']=="ware"){

                        $productos[] = [
                            'largo' => 0,
                            'alto' => 0,
                            'ancho' => 0,
                            'peso' => $orderItem->getWeight(),
                            'valor' => $declarado,
                            'valorContrareembolso' => 0,
                            'cantidad' => $cantidad,  // Pensado siempre como cross
                            'sku' => $orderItem->getWeight(), // Si es warehousing, en caso de crossdocking va vacio
                            'descripcionProducto' => '',
                        ];

                    }

                }

                if ($this->_config['modoEnvio']=="cross" || $this->_config['modoEnvio']==null){
                    
                    $productos[] = [
                        'largo' => 0,
                        'alto' => 0,
                        'ancho' => 0,
                        'peso' => $peso,
                        'valor' => $declarado,
                        'valorContrareembolso' => 0,
                        'cantidad' => 1,  // Pensado siempre como cross
                        'sku' => '', // Si es warehousing, en caso de crossdocking va vacio
                        'descripcionProducto' => '',
                    ];

                }

            break;

            case 'B':

                foreach ($order->getAllItems() as $orderItem) {
                   
                    if (!$orderItem->getQtyToShip() || $orderItem->getIsVirtual()) {
                        continue;
                    }
                    
                    $peso = 0;
                    $cantidad = $orderItem->getQtyOrdered();
                    $totalPrecio = $orderItem->getPrice() * $cantidad;

                    if ($this->declarado_porcentaje>0)
                        $declarado = ( $this->declarado_porcentaje * $totalPrecio ) / 100;
                    else
                        $declarado = $declarado_fijo;

                    $peso += $orderItem->getWeight();

                    if ($this->_config['modoEnvio']=="ware"){

                        $productos[] = [
                            'largo' => 0,
                            'alto' => 0,
                            'ancho' => 0,
                            'peso' => $orderItem->getWeight(),
                            'valor' => $declarado,
                            'valorContrareembolso' => $orderItem->getPrice(),
                            'cantidad' => $cantidad,  // Pensado siempre como cross
                            'sku' => $orderItem->getWeight(), // Si es warehousing, en caso de crossdocking va vacio
                            'descripcionProducto' => '',
                        ];

                    }

                }

                if ($this->_config['modoEnvio']=="cross" || $this->_config['modoEnvio']==null){
                    
                    $productos[] = [
                        'largo' => 0,
                        'alto' => 0,
                        'ancho' => 0,
                        'peso' => $peso,
                        'valor' => $declarado,
                        'valorContrareembolso' => $orderItem->getPrice(),
                        'cantidad' => 1,  // Pensado siempre como cross
                        'sku' => '', // Si es warehousing, en caso de crossdocking va vacio
                        'descripcionProducto' => '',
                    ];

                }

            break;
            
        }

        return $productos;
    }
}
