<?php

namespace Urbano\Shipping\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;
use Magento\Framework\App\ObjectManager;

class Contrareembolso implements ArrayInterface
{
    public function toOptionArray()
    {
        $objectManager = ObjectManager::getInstance();
 
        $orderPaymentCollection = $objectManager->get('\Magento\Sales\Model\ResourceModel\Order\Payment\Collection');
        $orderPaymentCollection->getSelect()->group('method');

        $paymentMethods[] = ['value' => '', 'label' => __('SIN CONTRAREEMBOLSO')];
        foreach ($orderPaymentCollection as $col) { 
            $paymentMethods[] = [
                'value' => $col->getMethod(),
                'label' => $col->getAdditionalInformation()['method_title']
            ];            
        }

        return $paymentMethods;
    }
}