<?php

namespace Urbanoppc\Shipping\Observer;

class CheckoutSubmitAllAfter implements \Magento\Framework\Event\ObserverInterface
{
    /** @var \Psr\Log\LoggerInterface */
    protected $_logger;

    /** @var \Magento\Framework\Message\ManagerInterface */
    protected $_messageManager;

    /** @var \Urbanoppc\Shipping\Helper\Urbano */
    protected $_urbano;

    /** @var \Urbanoppc\Shipping\Helper\Config */
    protected $_config;

    /**
     * @param \Psr\Log\LoggerInterface $logger
     * @param \Urbanoppc\Shipping\Helper\Urbano $urbano
     * @param \Urbanoppc\Shipping\Helper\Config $config
     * @param \Magento\Framework\Message\ManagerInterface $messageManager
     */
    public function __construct(
        \Psr\Log\LoggerInterface $logger,
        \Urbanoppc\Shipping\Helper\Urbano $urbano,
        \Urbanoppc\Shipping\Helper\Config $config,
        \Magento\Framework\Message\ManagerInterface $messageManager
    ) {
        $this->_logger = $logger;
        $this->_urbano = $urbano;
        $this->_config = $config->getConfig();
        $this->_messageManager = $messageManager;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        if (
          !$this->_config['active']
          || !$this->_config['activeFrontSend']
          || empty($this->_config['shipper'])
          || empty($this->_config['key'])
          ) {
            return false;
        }
      
        if ($observer->getEvent()->getOrder()->getShippingMethod() != "urbanoppc_shipping_urbanoppc_shipping") {
            return false;
        }

        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        
        $_order = $objectManager->get('Magento\Sales\Model\Order');
        $nroEnvio = $observer->getEvent()->getOrder()->getIncrementId();
        $order = $_order->loadByIncrementID($nroEnvio);
      
        if (!$order->canShip()) {
            $this->_messageManager->addErrorMessage(
                __('Su pedido ha sido creado, pero no se ha podido realizar el envio automatico. Notifique al administrador.')
            );
            return false;
        }

        $convertOrder = $objectManager->create('Magento\Sales\Model\Convert\Order');
        $shipment = $convertOrder->toShipment($order);

        $body = $this->_urbano->prepareBodyPostCargaClientes($order);

        foreach ($order->getAllItems() as $orderItem) {
            if (! $orderItem->getQtyToShip() || $orderItem->getIsVirtual()) {
                continue;
            }
          
            $qtyShipped = $orderItem->getQtyToShip();
            $shipmentItem = $convertOrder->itemToShipmentItem($orderItem)->setQty($qtyShipped);
            $shipment->addItem($shipmentItem);
        }

        $shipment->register();

        $request = $this->_urbano->postCargaClientes($body);
        if ($request['success'] == "false") {
            $this->_messageManager->addErrorMessage(
                __('Su pedido ha sido creado, pero no se ha podido generar automaticamente el numero de guia. Notifique al administrador.')
            );
          
            return false;
        }
        
        $data = [
            'carrier_code' => 'urbanoppc_shipping',
            'title' => 'Auto Tracking ID',
            'number' => $nroEnvio
        ];

        $shipment->getOrder()->setIsInProcess(true);
        
        try {
            $track = $objectManager->create('Magento\Sales\Model\Order\Shipment\TrackFactory')->create()->addData($data);
            $shipment->addTrack($track)->save();
            $shipment->save();
            $shipment->getOrder()->save();
            
            $objectManager->create('Magento\Shipping\Model\ShipmentNotifier')->notify($shipment);
            $shipment->save();
        } catch (\Exception $e) {
            throw new \Magento\Framework\Exception\LocalizedException(
                __($e->getMessage())
            );
        }
    }
}
