define([
    'jquery',
    'mage/utils/wrapper',
    'underscore'
], function ($, wrapper, _) {
    'use strict';

    return function (payloadExtender) {
        return wrapper.wrap(payloadExtender, function (originalFunction, payload) {
            var cp = document.getElementsByName("select_data");
            var shippingValue = cp[0] ? cp[0].value : "";          

            if (shippingValue) {

                // Dividimos la dirección del PPC para obtener los componentes individuales
                var direccionPPC = shippingValue.split(" - ");
                var codPpc = direccionPPC[0].slice(0, 3); 
                var calle = direccionPPC[1]; // "GRAL JOSE DE SAN MARTIN 67"
                var codigoPostal = direccionPPC[2]; // "1708"
                var provincia = direccionPPC[0]; // "G05"

                // Reemplazamos TODA la dirección de envío con la del PPC
                var shippingAddress = require('Magento_Checkout/js/model/quote').shippingAddress();
                shippingAddress.street = [calle];
                shippingAddress.city = codPpc; //"G05";//ciudad;
                shippingAddress.region = provincia; // Asigna la provincia como una cadena
                shippingAddress.postcode = codigoPostal;

                // Disparamos el evento 'change' para actualizar la interfaz
                const e = new Event("change");
                const element = document.querySelector('[name="postcode"]');
                element.dispatchEvent(e);
            } else {
                console.log("No se seleccionó ningún PPC o el valor está vacío.");
            }

            payload = originalFunction(payload);

            _.extend(payload.addressInformation, {
                extension_attributes: {
                    'shipping_date': shippingValue
                }
            });

            return payload;
        });
    };
});