;define([
    'jquery',
    'ko',
    'Magento_Ui/js/form/element/select',
    'Magento_Checkout/js/model/quote'
], function ($, ko, select, quote) {
    'use strict';

    var self;

    return select.extend({

        initialize: function () {
            self = this;
            this._super();
            this.selectedShippingMethod = quote.shippingMethod();

            quote.shippingMethod.subscribe(function(){

                var method = quote.shippingMethod();

                if(method && method['carrier_code'] == "urbanoppc_shipping") {
                    if(!self.selectedShippingMethod || (self.selectedShippingMethod && self.selectedShippingMethod['carrier_code'] != method['carrier_code'])) {
                        self.selectedShippingMethod = method;
                        self.updateDropdownValues(method);

                        //al seleccionar se actualiza el cp para ppc
                        $('select').on('change', function() {
                            if (document.getElementsByName("select_data")[0].value != ""){
                                var up_forms = document.getElementsByName("postcode");
                                var codigo_postal;
                                var cp = document.getElementsByName("select_data");
                                codigo_postal = cp[0].value;
                                up_forms[0].value = codigo_postal.substr(-4,4);
                                require('Magento_Checkout/js/model/quote').shippingAddress().postcode = up_forms[0].value;
                                //actualiza la modificacion
                                const e = new Event("change");
                                const element = document. querySelector('[name="postcode"]');
                                element.dispatchEvent(e);
                            }
                        });
                    }
                }else  {
                    //de lo contrario deja el listado vacio
                    document.getElementsByName("select_data")[0].value = "";
                    const f = new Event("change");
                    const element = document. querySelector('[name="select_data"]');
                    element.dispatchEvent(f);
                }

                
            }, null, 'change');
        },

        /**
         * Called when shipping method is changed.
         * Also called when initial selection is made.
         *
         * @param value
         * @returns {Object} Chainable
         */
        updateDropdownValues: function(method) {
            var valuesCollection = [];

            if(method['carrier_code'] == 'urbanoppc_shipping'){
                
                $.ajax('../urbano/sucursal/index',
                {
	              //url:this.baseUrl + "/urbano/sucursal/index",
	              contentType: "application/json",
	              crossDomain: true,
	              async:false,
	              success:function (data) {
                    

	                valuesCollection = data;
                    
	              },
	              error: function (xhr, ajaxOptions, thrownError) {
	                console.log("Error al inicializar la api de puntos de retiro.");
	              }
	            });
            }

            self.updateDropdown(valuesCollection);
        },

        /**
         * Called when option is changed in store selection list.
         * Also called when initial selection is made.
         *
         * @param value
         * @returns {Object} Chainable
         */
        updateDropdown: function(value) {
            this.setOptions(value);
        }
    });
});

