<?php

if (!defined('_PS_VERSION_')) {
    exit;
}


/**
 * @category Module
 * @author Urbano Express Argentina S. A.
 * @copyright Urbano Express Argentina S. A.
 * @version 1.2.1.3
 */

use PrestaShop\PrestaShop\Adapter\StockManager;
use PrestaShop\PrestaShop\Adapter\SymfonyContainer;

/**
 * @property Order $object
 */
class AdminGestionPedidosEnviadosController extends AdminController
{
    public $toolbar_title;

    protected $statuses_array = array();

    public function __construct()
    {
        $this->bootstrap = true;
        $this->table = 'order';
        $this->className = 'Order';
        $this->list_no_link = true;

        #$this->addRowAction('view');


        $this->explicitSelect = true;
        $this->allow_export = true;
        $this->deleted = false;

        parent::__construct();

        $this->_select = '
        a.id_order AS procesar_cliente,
		a.id_currency,
		a.id_order AS id_pdf,
		CONCAT(LEFT(c.`firstname`, 1), \'. \', c.`lastname`) AS `customer`,
		osl.`name` AS `osname`,
		os.`color`,
		IF((SELECT so.id_order FROM `' . _DB_PREFIX_ . 'orders` so WHERE so.id_customer = a.id_customer AND so.id_order < a.id_order LIMIT 1) > 0, 0, 1) as new,
		country_lang.name as cname,
		IF(a.valid, 1, 0) badge_success';
        $this->_where = ' AND (a.`current_state` = 5 || a.id_order IN (SELECT id_order FROM `' . _DB_PREFIX_ . 'uea_gestion_envio`) )AND a.`shipping_number` = "" AND (a.`id_carrier` IN (SELECT pc.id_carrier FROM ps_carrier pc WHERE pc.external_module_name = "enviourbano" ORDER BY pc.id_carrier) OR a.`id_carrier` = '.(int)Configuration::get('ID_CARRIER_URBANO') . ')';
        $this->_join = '
		LEFT JOIN `' . _DB_PREFIX_ . 'customer` c ON (c.`id_customer` = a.`id_customer`)
		INNER JOIN `' . _DB_PREFIX_ . 'address` address ON address.id_address = a.id_address_delivery
		INNER JOIN `' . _DB_PREFIX_ . 'country` country ON address.id_country = country.id_country
		INNER JOIN `' . _DB_PREFIX_ . 'country_lang` country_lang ON (country.`id_country` = country_lang.`id_country` AND country_lang.`id_lang` = ' . (int) $this->context->language->id . ')
		LEFT JOIN `' . _DB_PREFIX_ . 'order_state` os ON (os.`id_order_state` = a.`current_state`)
		LEFT JOIN `' . _DB_PREFIX_ . 'order_state_lang` osl ON (os.`id_order_state` = osl.`id_order_state` AND osl.`id_lang` = ' . (int) $this->context->language->id . ')';
        $this->_orderBy = 'id_order';
        $this->_orderWay = 'DESC';
        $this->_use_found_rows = true;

        $statuses = OrderState::getOrderStates((int) $this->context->language->id);
        foreach ($statuses as $status) {
            $this->statuses_array[$status['id_order_state']] = $status['name'];
        }

        $this->fields_list = array(
            'id_order' => array(
                'title' => $this->trans('ID', array(), 'Admin.Global'),
                'align' => 'text-center',
                'class' => 'fixed-width-xs',
            ),
            'reference' => array(
                'title' => "Seguimiento",
                'callback' => 'seguimiento',
                'remove_onclick' => true,
            ),
            'new' => array(
                'title' => $this->trans('New client', array(), 'Admin.Orderscustomers.Feature'),
                'align' => 'text-center',
                'type' => 'bool',
                'tmpTableFilter' => true,
                'orderby' => false,
                'callback' => 'printNewCustomer'
            ),
            'customer' => array(
                'title' => $this->trans('Customer', array(), 'Admin.Global'),
                'havingFilter' => true,
            ),
        );

        if (Configuration::get('PS_B2B_ENABLE')) {
            $this->fields_list = array_merge($this->fields_list, array(
                'company' => array(
                    'title' => $this->trans('Company', array(), 'Admin.Global'),
                    'filter_key' => 'c!company',
                ),
            ));
        }

        $this->fields_list = array_merge($this->fields_list, array(
            'total_paid_tax_incl' => array(
                'title' => $this->trans('Total', array(), 'Admin.Global'),
                'align' => 'text-right',
                'type' => 'price',
                'currency' => true,
                'callback' => 'setOrderCurrency',
                'badge_success' => true,
            ),
            'payment' => array(
                'title' => $this->trans('Payment', array(), 'Admin.Global'),
            ),
            'osname' => array(
                'title' => $this->trans('Status', array(), 'Admin.Global'),
                'type' => 'select',
                'color' => 'color',
                'list' => $this->statuses_array,
                'filter_key' => 'os!id_order_state',
                'filter_type' => 'int',
                'order_key' => 'osname',
            ),
            'date_add' => array(
                'title' => $this->l('Date'),
                'align' => 'text-right',
                'type' => 'datetime',
                'filter_key' => 'a!date_add'
            ),
            'id_pdf' => array(
                'title' => $this->l('Etiqueta'),
                'align' => 'text-center',
                'callback' => 'printEtiqueta',
                'orderby' => false,
                'search' => false,
                'remove_onclick' => true

            )
        ));

        if (Country::isCurrentlyUsed('country', true)) {
            $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT DISTINCT c.id_country, cl.`name`
			FROM `' . _DB_PREFIX_ . 'orders` o
			' . Shop::addSqlAssociation('orders', 'o') . '
			INNER JOIN `' . _DB_PREFIX_ . 'address` a ON a.id_address = o.id_address_delivery
			INNER JOIN `' . _DB_PREFIX_ . 'country` c ON a.id_country = c.id_country
			INNER JOIN `' . _DB_PREFIX_ . 'country_lang` cl ON (c.`id_country` = cl.`id_country` AND cl.`id_lang` = ' . (int) $this->context->language->id . ')
			ORDER BY cl.name ASC');

            $country_array = array();
            foreach ($result as $row) {
                $country_array[$row['id_country']] = $row['name'];
            }

            $part1 = array_slice($this->fields_list, 0, 3);
            $part2 = array_slice($this->fields_list, 3);
            $part1['cname'] = array(
                'title' => $this->trans('Delivery', array(), 'Admin.Global'),
                'type' => 'select',
                'list' => $country_array,
                'filter_key' => 'country!id_country',
                'filter_type' => 'int',
                'order_key' => 'cname',
            );
            $this->fields_list = array_merge($part1, $part2);
        }

        $this->shopLinkType = 'shop';
        $this->shopShareDatas = Shop::SHARE_ORDER;

        if (Tools::isSubmit('id_order')) {
            // Save context (in order to apply cart rule)
            $order = new Order((int) Tools::getValue('id_order'));
            $this->context->cart = new Cart($order->id_cart);
            $this->context->customer = new Customer($order->id_customer);
        }


        //Mostrar resultados por button y pdf de impresion por lote
        if (Tools::isSubmit('submitBulksendPrint'.$this->table)) {
            $row_array = Tools::getValue($this->table.'Box');
            $shipper   = Tools::getValue('ID_SHIPPER_URBANO', Configuration::get('ID_SHIPPER_URBANO'));
            $datos_impresion = array();
            #verifica si hay procesos por lote
            try {
   
                if (count($row_array))
                {   
                    foreach($row_array as $id_order){
                        $order = new Order((int) $id_order);
                        $message = $order->getFirstMessage();
                        #$customer = $this->context->customer;
                        $customer = new Customer((int)$order->id_customer);
                        #$cart = $this->context->cart;new Address((int)$order->id_address_delivery);
                        $address = new Address((int)$order->id_address_delivery);
                        $data->autentificacion = new stdClass();
                        $data->autentificacion->shipper  = Configuration::get('ID_SHIPPER_URBANO');
                        $data->autentificacion->password = Configuration::get('KEY_SHIPPER_URBANO');
                        $respuesta = [
                        'cli_codigo' => $order->reference,
                        'nombre' => $customer->firstname." ".$customer->lastname,
                        'calle' => $address->address1.' '.$address->address2,
                        'altura' =>"",
                        'piso' =>"",
                        'dpto' =>"",
                        'cp' => $address->postcode,
                        'localidad' => $address->city,
                        'provincia' => State::getNameById((int)$address->id_state),
                        'telefono' => $address->phone,
                        'shipper' => Configuration::get('ID_SHIPPER_URBANO'),
                        'ciudad' => $address->city,
                        'observacion' => preg_replace('([^A-Za-z0-9 ])', '', $message),
                        ];
                        array_push($datos_impresion, $respuesta);//para agregar nuevo elemento al array  
                    }
                    $lote = json_encode($datos_impresion);
                }
                if ($datos_impresion) {
                    if($datos_impresion->codError == 0)
                    {
                        $endpoint = Tools::getValue('ENDPOINT_SERVICIO_URBANO', Configuration::get('ENDPOINT_SERVICIO_URBANO'));
                        $lote = json_encode($datos_impresion);
                        //Generamos la funcion para el proceso para la url de impresion
                        echo "<script>
                        function porLote(){
                            var lote;
                            lote = encodeURI('https://$endpoint/impresionEtiqueta?tipo=A4&datos=$lote');
                            window.open(lote);
                        }
                        porLote();
                        </script>";
                        $msj = "<br/>&nbsp;<p>Importante. Las etiquetas de pedidos que no esten en urbano o pedidos que no esten emitidos, siempre van a ser impresas en el proceso por lotes, aunque no se haya generado el envio.</p>";
                        $boton = "<button onclick=porLote() class='btn btn-default'>Visualizar pdf de etiqueta</button>";
                        #mostramos el boton de impresion.
                        $this->confirmations[] = $boton . $msj;
                    }else
                    {   
                        $this->errors[] = $this->trans($datos_impresion->descError, array(), 'Admin.Orderscustomers.Notification');
                    }
                } else {
                    $this->errors[] = $this->trans('Debe seleccionar al menos una etiqueta.', array(), 'Admin.Notifications.Error');
                }

            } catch (Exception $e) {
                // Este bloque de código sólo se ejecuta si se ha producido una 
                // excepción al intentar ejecutar el bloque previo.
                $this->errors[] = $this->trans('Error en obtener la orden para generar PDF de impresion por lote.', array(), 'Admin.Notifications.Error');

            } finally {
                // Esta parte es opcional y, si existe, se ejecutará tanto si se ha podido efectuar 
                // el proceso, como si se ha producido una excepción.
            }

        }

        $this->bulk_actions = array(
            'sendPrint' => array('text' => 'Generar etiquetas por lotes', 'icon' => 'icon-print'),
        );
    }

    public static function setOrderCurrency($echo, $tr)
    {
        if (!empty($tr['id_currency'])) {
            $idCurrency = (int) $tr['id_currency'];
        } else {
            $order = new Order($tr['id_order']);
            $idCurrency = (int) $order->id_currency;
        }

        return Tools::displayPrice($echo, $idCurrency);
    }

    public function initToolbar()
    {
        if ($this->display == 'view') {
            /** @var Order $order */
            $order = $this->loadObject();
            $customer = $this->context->customer;

            if (!Validate::isLoadedObject($order)) {
                Tools::redirectAdmin($this->context->link->getAdminLink('AdminOrders'));
            }

            $this->toolbar_title[] = $this->trans(
                'Order %reference% from %firstname% %lastname%',
                array(
                    '%reference%' => $order->reference,
                    '%firstname%' => $customer->firstname,
                    '%lastname%' => $customer->lastname,
                ),
                'Admin.Orderscustomers.Feature'
            );
            $this->addMetaTitle($this->toolbar_title[count($this->toolbar_title) - 1]);

            if ($order->hasBeenShipped()) {
                $type = $this->trans('Return products', array(), 'Admin.Orderscustomers.Feature');
            } elseif ($order->hasBeenPaid()) {
                $type = $this->trans('Standard refund', array(), 'Admin.Orderscustomers.Feature');
            } else {
                $type = $this->trans('Cancel products', array(), 'Admin.Orderscustomers.Feature');
            }

            if (!$order->hasBeenShipped() && !$this->lite_display) {
                $this->toolbar_btn['new'] = array(
                    'short' => 'Create',
                    'href' => '#',
                    'desc' => $this->trans('Add a product', array(), 'Admin.Orderscustomers.Feature'),
                    'class' => 'add_product',
                );
            }

            if (Configuration::get('PS_ORDER_RETURN') && !$this->lite_display) {
                $this->toolbar_btn['standard_refund'] = array(
                    'short' => 'Create',
                    'href' => '',
                    'desc' => $type,
                    'class' => 'process-icon-standardRefund',
                );
            }

            if ($order->hasInvoice() && !$this->lite_display) {
                $this->toolbar_btn['partial_refund'] = array(
                    'short' => 'Create',
                    'href' => '',
                    'desc' => $this->trans('Partial refund', array(), 'Admin.Orderscustomers.Feature'),
                    'class' => 'process-icon-partialRefund',
                );
            }
        }
        $res = parent::initToolbar();
        if (Context::getContext()->shop->getContext() != Shop::CONTEXT_SHOP && isset($this->toolbar_btn['new']) && Shop::isFeatureActive()) {
            unset($this->toolbar_btn['new']);
        }

        return $res;
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);

        $this->addJqueryUI('ui.datepicker');
        $this->addJS(_PS_JS_DIR_ . 'vendor/d3.v3.min.js');
        $this->addJS('https://maps.googleapis.com/maps/api/js?v=3.exp');

        $this->addJs(_PS_MODULE_DIR_ . 'enviourbano/js/enviourbano.js');
        
        if ($this->access('edit') && $this->display == 'view') {
            
            $this->addJS(_PS_JS_DIR_ . 'tools.js');
            $this->addJqueryPlugin('autocomplete');
            $this->addJS(_PS_JS_DIR_ . 'admin/orders.js');
        }
    }

    public function printEtiqueta($id_order, $tr)
    {
        $shipper=Tools::getValue('ID_SHIPPER_URBANO', Configuration::get('ID_SHIPPER_URBANO'));
        $endpoint=Tools::getValue('ENDPOINT_SERVICIO_URBANO', Configuration::get('ENDPOINT_SERVICIO_URBANO'));
        return "<a href='https://".$endpoint."/impresionEtiqueta/?tipo=A4&shipper=".$shipper."&codSeguimiento=". $tr["reference"] ."' target='_blank' class='btn btn-default'><i class='icon-print'></i> Imprimir</a>";
    }//Imprime la etiqueta de Urbano


    public function seguimiento($id_order, $tr)
    {
        $shipper=Tools::getValue('ID_SHIPPER_URBANO', Configuration::get('ID_SHIPPER_URBANO'));
        $endpoint=Tools::getValue('ENDPOINT_SERVICIO_URBANO', Configuration::get('ENDPOINT_SERVICIO_URBANO'));
        return "<a href='https://".$endpoint."/cespecifica/?shi_codigo=".$shipper."&cli_codigo=".$tr["reference"]."' target='_blank' class='btn btn-default'>".$tr["reference"]."</a>";
    }//Imprime el seguimiento de Urbano



    public function printNewCustomer($id_order, $tr)
    {
        return ($tr['new'] ? $this->l('Yes') : $this->l('No'));
    }

    public function processBulkUpdateOrderStatus()
    {

    }

    public function renderList()
    {
        if (Tools::isSubmit('submitBulkupdateOrderStatus' . $this->table)) {
            if (Tools::getIsset('cancel')) {
                Tools::redirectAdmin(self::$currentIndex . '&token=' . $this->token);
            }

            $this->tpl_list_vars['updateOrderStatus_mode'] = true;
            $this->tpl_list_vars['order_statuses'] = $this->statuses_array;
            $this->tpl_list_vars['REQUEST_URI'] = $_SERVER['REQUEST_URI'];
            $this->tpl_list_vars['POST'] = $_POST;
        }

        return parent::renderList();
    }
    
}
