<?php
error_reporting(0);

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WC_Shipping_Uea class.
 *
 * @extends WC_Shipping_Method
 */
class WC_Shipping_Uea extends WC_Shipping_Method {

	//Definiciones
	public $debug;
    public $api_user;
    public $endpoint;
    public $porcentaje_iva;
    public $api_password;
    public $modo_envio;
    public $listado_ppc;
    public $redondear_total;
    public $auto_impacto;
    public $envio_gratis;
    public $costo_fijo;
    public $numeracion;
    public $bultos_orden;
    public $contrareembolso;
    public $declarado;
    public $ppc_active;
    public $limite_envio_gratis;
	public $init_form_fields = array();

	/**
	 * Constructor
	 */
	public function __construct( $instance_id = 0 ) {

		$this->id                   = 'uea_ueforwoocom';
		$this->instance_id 			= absint( $instance_id );
		$this->method_title         = __( 'Urbano Argentina', 'woocommerce-shipping-uea' );
		$this->method_description   = __( 'Permite integracion con Urbano Argentina. (IMPORTANTE: Debe contar con los datos provistos por UA para poder usarlo)', 'woocommerce' );
		$this->supports             = array(
			'shipping-zones',
			'instance-settings',
		);

		$this->init();

		add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );


	}

	/**
	 * init function.
	 */
	public function init() {
		// Load the settings.
		$this->init_form_fields = include( 'data/data-settings.php' );
		$this->init_settings();
		$this->instance_form_fields = include( 'data/data-settings.php' );

		// Define user set variables
		$this->debug            = ( $bool = $this->get_option( 'debug' ) ) && $bool == 'yes' ? true : false;
		$this->title            = $this->get_option( 'title', $this->method_title );
		$this->api_user		    = $this->get_option( 'api_user' );
		$this->endpoint		    = $this->get_option( 'endpoint' );
		$this->porcentaje_iva	= $this->get_option( 'porcentaje_iva' );
		$this->api_password		= $this->get_option( 'api_password' );
		$this->modo_envio		= $this->get_option( 'modo_envio' );
		$this->listado_ppc		= $this->get_option( 'listado_ppc' );

		$this->redondear_total  = ( $bool = $this->get_option( 'redondear_total' ) ) && $bool == 'yes' ? true : false;
		$this->auto_impacto     = $this->get_option( 'auto_impacto' );
		$this->envio_gratis     = $this->get_option('envio_gratis') === 'yes';
		$this->costo_fijo       = $this->get_option( 'costo_fijo' );
		$this->numeracion		= $this->get_option( 'numeracion' );
		$this->bultos_orden     = ( $bool = $this->get_option( 'bultos_orden' ) ) && $bool == 'yes' ? true : false;
		$this->contrareembolso  = ( $bool = $this->get_option( 'contrareembolso' ) ) && $bool == 'yes' ? true : false;
		$this->declarado        = $this->get_option( 'declarado' );
		$this->ppc_active       = ( $bool = $this->get_option( 'ppc_active' ) ) && $bool == 'yes' ? true : false;
		$this->limite_envio_gratis = ($this->get_option( 'limite_envio_gratis' )) ? $this->get_option( 'limite_envio_gratis' ) : 0;
	}

	/**
	 * Output a message
	 */
	public function debug( $message, $type = 'notice' ) {
		if ( $this->debug ) {
			wc_add_notice( $message, $type );
		}
	}

	/**
	 * environment_check function.
	 */
	private function environment_check() {
		if ( ! in_array( WC()->countries->get_base_country(), array( 'AR' ) ) ) {
			echo '<div class="error">
				<p>' . __( 'Argentina tiene que ser el pais de Origen.', 'woocommerce-shipping-uea' ) . '</p>
			</div>';
		}
	}

	/**
	 * admin_options function.
	 */
	public function admin_options() {
		$this->environment_check();
		parent::admin_options();
	}


	public function get_uea_packages( $package ) {
		return $this->per_item_shipping( $package );
	}

	/**
	 * per_item_shipping function.
	 *
	 * @access private
	 * @param mixed $package
	 * @return array
	 */
	private function per_item_shipping( $package ) {
		$to_ship  = array();
		$group_id = 1;

		// Get weight of order
		foreach ( $package['contents'] as $item_id => $values ) {

			if ( ! $values['data']->needs_shipping() ) {
				$this->debug( sprintf( __( 'Product # is virtual. Skipping.', 'woocommerce-shipping-uea' ), $item_id ), 'error' );
				continue;
			}

			if ( ! $values['data']->get_weight() ) {
				$this->debug( sprintf( __( 'Product # is missing weight. Aborting.', 'woocommerce-shipping-uea' ), $item_id ), 'error' );
				return;
			}

			$group = array();

			$group = array(
				'GroupNumber'       => $group_id,
				'GroupPackageCount' => $values['quantity'],
				'Weight' => array(
					'Value' => $values['data']->get_weight(),
					'Units' => 'KG'
				),
				'packed_products' => array( $values['data'] )
			);

			if ( $values['data']->get_length() && $values['data']->get_height() && $values['data']->get_width() ) {

				$dimensions = array( $values['data']->get_length(), $values['data']->get_width(), $values['data']->get_height() );

				sort( $dimensions );

				$group['Dimensions'] = array(
					'Length' => $values['data']->get_length(),
					'Width'  => $values['data']->get_width(),
					'Height' => $values['data']->get_height(),
					'Units'  => 'CM'
				);
			}

			$group['InsuredValue'] = array(
				'Amount'   => round( $values['data']->get_price() ),
				'Currency' => get_woocommerce_currency()
			);

			$to_ship[] = $group;

			$group_id++;
		}

		return $to_ship;
	}


	/**
	 * calculate_shipping function.
	 *
	 * @param mixed $package	
	 */
	public function calculate_shipping( $package = array() ) {

		global $wp_session;

		$checkout = false;

		if ( ! session_id() ) {
			session_start();
		}

		// Eliminamos el PPC seleccionado para que no quede seleccionada en el CART
		if ( is_cart() ) {
			unset($_SESSION['punto_r']);
			unset($_SESSION['id_ppc']);
		}
	
		$this->debug( __( 'Urbano Argentina modo de depuración está activado - para ocultar estos mensajes, desactive el modo de depuración en los ajustes.', 'woocommerce-shipping-uea' ) );
		
			error_log('calculate_shipping.');
		

		$uea_packages   = $this->get_uea_packages( $package );

		$uea_package = $uea_packages[0]['GroupPackageCount'];
		$dimension_unit = esc_attr( get_option('woocommerce_dimension_unit' ));
		$weight_unit = esc_attr( get_option('woocommerce_weight_unit' ));
		$weight_multi = 0;
		$dimension_multi = 0;
		if ($dimension_unit == 'm') { $dimension_multi =  1;}
		if ($dimension_unit == 'cm') {  $dimension_multi =  100;}
		if ($dimension_unit == 'mm') { $dimension_multi =  1000;}
		if ($weight_unit == 'kg') { $weight_multi =  1;}
		if ($weight_unit == 'g') {  $weight_multi =  0.001;}
		$uea_weightb = 0;
		$uea_volumesy = 0;
		foreach ($uea_packages as $key) {
			$uea_package = $key['GroupPackageCount'];
			$uea_weight = $key['Weight']['Value'] * $weight_multi;
			$uea_lenth = $key['Dimensions']['Length'] / $dimension_multi;
			$uea_width = $key['Dimensions']['Width'] / $dimension_multi;
			$uea_height = $key['Dimensions']['Height'] / $dimension_multi;
			$uea_amount = $key['InsuredValue']['Amount'];
			$uea_weightb += $uea_weight * $uea_package;
			$uea_volume = $uea_lenth * $uea_width * $uea_height;
			$uea_volumesy += $uea_volume * $uea_package;
			$uea_volumesy = number_format($uea_volumesy, 10);
			$uea_packageb = 1;
		}

		$ppc = false;
		$ppc_datos = array();
		$sucursales = array();

		$seguro = round($package['contents_cost']);

		$envio_gratis = $this->envio_gratis;
		$notificacion_envio_gratis = "";

		if ($envio_gratis !== true) { // Si el envio NO ES GRATIS

			// --- si el subtotal del carrito es mayor al 'limite_envio_gratis' el envio es gratuito
			if (isset($package['cart_subtotal']) && !empty($this->limite_envio_gratis) && $package['cart_subtotal'] > $this->limite_envio_gratis) {

				//echo "ENVIO GRATIS";
				$envio_gratis = 1;
				$notificacion_envio_gratis = " (Gratis)";

			}

		} else { // Si el envio ES GRATIS == 1

			$notificacion_envio_gratis = " (Gratis)";

		}

		$numeracion = $this->numeracion;
		$porcentaje_iva = $this->porcentaje_iva;
		$costo_fijo = $this->costo_fijo;
		
		$uea_volumesy = $uea_volumesy == null ? $uea_volumesy : 0;

		if( isset($_SESSION["punto_r"]) && $_SESSION["punto_r"] === "true"){

			/**
			 * Si se elige algun PPC o Sucursal
			 */
			$sucursales = $_SESSION['sucursales_ppc'];
			
			//error_log('Sucursales en sesion (calculate_shipping): ' . print_r($sucursales, true)); // <-- Nuevo log
			preg_match('/\((.*?)\)/', $_SESSION['address_ppc'], $matches);
			$id = $matches[1];
			//error_log('ID extraido (calculate_shipping): ' . $id); // <-- Nuevo log
			$k = array_search($id, array_column($sucursales, 'prov_codigo'));
			//error_log('Clave encontrada (calculate_shipping): ' . print_r($k, true)); // <-- Nuevo log

			// Verifica si la clave $k es válida
			if ($k !== false && isset($sucursales[$k]['tarifa'])) {
				$tarifa_ppc = (int)$sucursales[$k]['tarifa'];
			//	error_log('TARIFA PPC encontrada (calculate_shipping): ' . print_r($tarifa_ppc, true)); // <-- Tu log existente, ahora con más contexto
			} else {
					$tarifa_ppc = 0; // Asegúrate de que sea 0 si no se encuentra
				//	error_log('ERROR: No se pudo encontrar la tarifa para el ID ' . $id . ' en las sucursales de la sesión, o la clave tarifa no existe.'); // <-- Nuevo log de error
			}

			$codigo_postal = sanitizarCodigoPostal($sucursales[$k]['codigoPostal']);

			$ppc =  true;
			$provincia = $sucursales[$k]['provincia'] ? $sucursales[$k]['provincia'] : $sucursales[$k]['municipalidad'];
            $direccion = $provincia . ' - ' . $sucursales[$k]['direccion'];
            $tarifa_ppc = (int)$sucursales[$k]['tarifa'];
			//error_log('TARIFA PPC: ' . print_r($tarifa_ppc, true));
			$ppc_datos = array(
				'id_ppc' => $_SESSION["id_ppc"],
				'direccion' => $direccion,
				'locacion' => $sucursales[$k]['localidad'],
				'codigo_postal' => $codigo_postal,
				'provincia' => $sucursales[$k]['provincia'],
				'prov_codigo' => $sucursales[$k]['prov_codigo'],
			);
			$ppc_active_origen = $this->ppc_active;
			$ppc_origen = $ppc;
			$ppc_datos_origen = $ppc_datos;
		
			// Calculo de la tarifa para envio PPC o Sucursal
			$tarifa = ($costo_fijo && is_numeric($costo_fijo)) ? $costo_fijo : $tarifa_ppc;
			$tarifa = $envio_gratis ? 0 : $tarifa;
			$title = $envio_gratis ?  $this->title." (Gratis)" :  $this->title;
		
			$redondear_total = $this->redondear_total;
			$tarifa = $redondear_total ? round($tarifa, 0, PHP_ROUND_HALF_UP) : $tarifa;
			if (is_numeric($porcentaje_iva) && $porcentaje_iva > 0) {
				$tarifa = $tarifa + ($tarifa * $porcentaje_iva) / 100;
			}

			$title = "[Sucursal o PPC] - (" . $sucursales[$k]['prov_codigo'] . ") " . $direccion . " - Urbano Express" . $notificacion_envio_gratis;

		}else{ 

			/**
			 * Envio Normal
			 */

			$codigo_postal = sanitizarCodigoPostal($package['destination']['postcode']);

			$params = array(
				"autentificacion" => array(
					'shipper' => $this->api_user,
					'password' => $this->api_password,
				),
				'codigoPostal' => $codigo_postal,
				'pesoEspecifico' => $uea_weightb,
				'pesoVolumetrico' => $uea_volumesy,
			);
			$params = json_encode($params);
			if ($this->endpoint==""){
				$ch = curl_init($wp_session['url_uea'].'consulta_tarifa_rest/');
			}else{
				$ch = curl_init($this->endpoint.'consulta_tarifa_rest/');
			}//si el endpoint del formulario esta vacio ingresa por defecto el endpoint de produccion
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
			$error = curl_error ( $ch );
			$uea_response = curl_exec ($ch);
			$uea_response = json_decode($uea_response,true);

			// Calculo de la tarifa para envio normal
			$tarifa = ($costo_fijo && is_numeric($costo_fijo))? $costo_fijo : $uea_response['valorTarifa'];
			$tarifa = $envio_gratis ? 0 : $tarifa;
			$title = $envio_gratis ?  $this->title." (Gratis)" :  $this->title;
		
			if($uea_response['codError'] === 0 && $tarifa ) {				
				$redondear_total = $this->redondear_total;
				$tarifa = $redondear_total ? round($uea_response['valorTarifa'], 0, PHP_ROUND_HALF_UP) : $tarifa;
				if (is_numeric($porcentaje_iva) && $porcentaje_iva>0)
					$tarifa = $tarifa+($tarifa*$porcentaje_iva)/100;
			
			}
		}

		$origen_datos[] = array (
			'api_user' => $this->api_user,
			'api_password' => $this->api_password,
			'porcentaje_iva' => $this->porcentaje_iva,
			'modo_envio' => $this->modo_envio,
			'listado_ppc' => $this->listado_ppc,
			'contrareembolso' => $this->contrareembolso,
			'declarado' => $this->declarado,
			'uea_lenth' => $uea_lenth,
			'uea_width' => $uea_width,
			'uea_height' => $uea_height,
			'uea_amount' => $uea_amount,
			'uea_weightb' => $uea_weightb,
			'auto_impacto' => $this->auto_impacto,
			'bultos_orden' => $this->bultos_orden,
			'envio_gratis' => $this->envio_gratis,
			'limite_envio_gratis' => $this->limite_envio_gratis,
			'costo_fijo' => $this->costo_fijo,
			'numeracion' => $this->numeracion,
			'endpoint' => $this->endpoint,
			'ppc_active' => $ppc_active_origen ?? false,
			'ppc' => $ppc_origen ?? null,
			'ppc_datos' => $ppc_datos_origen ?? null
		);

		$origen_datos = json_encode($origen_datos);
		$_SESSION['origen_datos_uea'] = $origen_datos;	
	
	
		$rate = array(
			'id' => $this->id,
			'label' => sprintf("%s", $title),
			'cost' => $tarifa,
		);
		$this->add_rate( $rate );
	}
}