<?php
//define('WP_DEBUG', true); //borrar solo testeo

/**
 * Agregado de Estilos y JS
 */
function mi_plugin_admin_styles() {
    ?>
    <style type="text/css">
        .boton-cerrar-especial {
            background-color:rgb(50, 95, 220) !important; /* Un rojo llamativo */
            color: white !important;
            border: 1px solid black !important;
            border-radius: 4px !important;
            padding: 5px 15px !important;
            cursor: pointer !important;
            font-size: 14px !important;
            box-shadow: 1px 1px 3px rgba(0, 0, 0, 0.3) !important;
        }

        .boton-cerrar-especial:hover {
            background-color:rgb(43, 132, 192) !important;
        }

        .boton-azul-especial {
            background-color:rgb(50, 95, 220) !important; /* Un rojo llamativo */
            color: white !important;
            border: 1px solid black !important;
            border-radius: 4px !important;
            padding: 6px 15px !important;
            cursor: pointer !important;
            font-size: 14px !important;
            box-shadow: 1px 1px 3px rgba(0, 0, 0, 0.3) !important;
        }

        .boton-azul-especial:hover {
            background-color:rgb(43, 132, 192) !important;
        }

        .boton-gris-especial {
            background-color:rgb(123, 124, 124) !important; /* Un rojo llamativo */
            color: white !important;
            border: 1px solid black !important;
            border-radius: 4px !important;
            padding: 5px 15px !important;
            cursor: pointer !important;
            font-size: 14px !important;
            box-shadow: 1px 1px 3px rgba(0, 0, 0, 0.3) !important;
        }

        .boton-gris-especial:hover {
            background-color:rgb(168, 169, 170) !important;
        }

        #modalConfirmacion {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: #fff;
            border: 1px solid #ccc;
            padding: 20px;
            z-index: 10000;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            border-radius: 5px;
            text-align: center;
        }

        #modalConfirmacion button {
            margin: 0 10px;
            padding: 8px 15px;
            border-radius: 4px;
            cursor: pointer;
        }

        #overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.89);
            z-index: 9999;
        }
    </style>
    <?php

    // Agregamos la librería Lottie-web (necesaria para usar la animación JSON del Loading de Urbano)
    wp_enqueue_script(
        'lottie-web', // Handle único
        'https://cdnjs.cloudflare.com/ajax/libs/lottie-web/5.10.2/lottie.min.js', // URL del CDN
        array(), // Sin dependencias
        '5.10.2', // Versión
        true // Cargar antes de </body>
    );

    // Agregamos el JavaScript que contiene mostrarLoadingUrbano y ocultarLoadingUrbano
    wp_enqueue_script(
        'urbano-logo-animation', // Handle único para tu script
        plugin_dir_url(__FILE__) . 'js/animacion_logo_urbano.js',
        array('jquery', 'lottie-web'), // Depende de jQuery y Lottie-web
        '1.0', // Versión de tu archivo JS (la cambiamos si modificamos el archivo para evitar problemas de caché)
        true // Cargar antes de </body>
    );

    // Asociamos estos datos al script 'urbano-logo-animation' o a otro si prefieres
    $json_url = plugin_dir_url(__FILE__) . 'js/urbano_loading.json';
    wp_localize_script(
        'urbano-logo-animation', // Asocia estos datos a tu script 'urbano-logo-animation'
        'urbanoAnimationData', // Nombre del objeto JS global (ej: urbanoAnimationData.jsonUrl)
        array(
            'jsonUrl' => $json_url, // PASAMOS LA URL COMPLETA CALCULADA
        )
    );
}
add_action( 'admin_enqueue_scripts', 'mi_plugin_admin_styles' );


/**
 * Hook para crear el div donde vamos a cargar el Loading de Urbano
 */
function urbano_add_loading_overlay_html() {
    // Solo agregar este HTML en las páginas de pedidos de WooCommerce
    $is_shop_order_page = (isset($_GET['post_type']) && $_GET['post_type'] == 'shop_order');
    $is_wc_orders_page = (isset($_GET['page']) && $_GET['page'] == 'wc-orders');

    if ($is_shop_order_page || $is_wc_orders_page) {
        ?>
        <!-- HTML para la pantalla oscura y el contenedor de la animación -->
        <div id="pantallaOscura" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.89); z-index: 9999; justify-content: center; align-items: center;">
        <button id="cerrarLoadingUrbano" onclick="ocultarLoadingUrbano();" style="position: absolute; top: 20px; right: 20px; background: #fff; border: 1px solid #ccc; border-radius: 50%; width: 30px; height: 30px; cursor: pointer; font-size: 16px; line-height: 1; text-align: center; padding: 0; margin-top: 50px;">&times;</button>
            <div id="lottie-animation" style="width: 150px; height: 150px;">
                <!-- La animación Lottie se renderizará dentro de este div -->
            </div>
        </div>
        <?php
    }
}
add_action('admin_footer', 'urbano_add_loading_overlay_html');


/**
 * Funcion para asignar prefijo a los numeros de seguimiento
 */
function prefix($tracking,$prex){
    $seguimiento = (int)$tracking;
    if ( $seguimiento > 0 ){
        if ( strlen($seguimiento) <= 9 ){
            $rest = str_pad($prex.$seguimiento, 10, "0", STR_PAD_LEFT);
            $rest = substr($rest, -10);
            return $rest;
        }
    }
    return $tracking;
}

/**
 * Funcion para obtener todos los datos de la orden
 */
function order_collect_data($order, $origen_datos)
{
    $data = array();
    $contrareembolso = ($origen_datos['contrareembolso']) ? $order->get_total() : 0;
    $declarado = $origen_datos['declarado'];
    if (isset($origen_datos["modo_envio"]) && $origen_datos["modo_envio"] == "ware"){
        $items = $order->get_items();
        $key = 0;
        foreach ($items as $item){
            $product = wc_get_product( $item['product_id'] );
            $data['data']['productos'][$key]['valorContrareembolso'] = $contrareembolso;

            if ($declarado)
                $data['data']['productos'][$key]['valor'] = ($declarado * $order->get_subtotal()) / 100;
            else
                $data['data']['productos'][$key]['valor'] = 0;
            
            $data['data']['productos'][$key]['cantidad'] = $item['qty'];
            $data['data']['productos'][$key]['sku'] = $product->get_sku();
            $data['data']['productos'][$key]['largo'] = $origen_datos['uea_lenth'];
            $data['data']['productos'][$key]['alto'] = $origen_datos['uea_height'];
            $data['data']['productos'][$key]['ancho'] = $origen_datos['uea_width'];
            $data['data']['productos'][$key]['peso'] = $origen_datos['uea_weightb'];
            $key+=1;
        }
    }else{
        $data['data']['productos'][0]['valorContrareembolso'] = $contrareembolso;

        if ($declarado)
            $data['data']['productos'][0]['valor'] = ($declarado * $order->get_subtotal()) / 100;
        else
            $data['data']['productos'][0]['valor'] = 0;
        
        $data['data']['productos'][0]['cantidad'] = '1';
        $data['data']['productos'][0]['sku'] = '';
        $data['data']['productos'][0]['largo'] = $origen_datos['uea_lenth'];
        $data['data']['productos'][0]['alto'] = $origen_datos['uea_height'];
        $data['data']['productos'][0]['ancho'] = $origen_datos['uea_width'];
        $data['data']['productos'][0]['peso'] = $origen_datos['uea_weightb'];
    }
    $data['data']['productos'][0]['descripcionProducto'] = 'Pedido realizado a través de WooCommerce, Plugin version: '.PLUGIN_VERSION_ACTUAL;
    $data['data']['autentificacion']['shipper'] = $origen_datos['api_user'];
    $data['data']['autentificacion']['password'] = $origen_datos['api_password'];
    $data['data']['autentificacion']['endpoint'] = $origen_datos['endpoint'];
    $data['data']['porcentaje_iva'] = $origen_datos['porcentaje_iva'];
    $data['data']['envio_gratis'] = $origen_datos['envio_gratis'];
    $data['data']['ppc_active'] = $origen_datos['ppc_active'];
    $data['data']['destinatario']['tipoDocumento'] = '';
    $data['data']['destinatario']['numeroDocumento'] = '';
    $data['data']['destinatario']['nombre'] = $order->get_formatted_shipping_full_name();
    $data['data']['destinatario']['email'] = $order->get_billing_email();
    $data['data']['destinatario']['telefono'] = $order->get_billing_phone();
    $data['data']['destinatario']['celular'] = $order->get_billing_phone();
    $data['data']['autorizado'][0]['tipoDocumento'] = '';
    $data['data']['autorizado'][0]['numeroDocumento'] = '';
    $data['data']['autorizado'][0]['nombre'] = $order->get_formatted_shipping_full_name();
    $data['data']['autorizado'][0]['email'] = $order->get_billing_email();
    $data['data']['autorizado'][0]['telefono'] = $order->get_billing_phone();
    $data['data']['autorizado'][0]['celular'] = $order->get_billing_phone();
    //Verificar si está siendo enviado a un punto de retiro
    $code_id_ppc = NULL;
    $direccion = preg_replace('([^A-Za-z0-9 ])', '', $order->get_shipping_address_1()) . ' ' . preg_replace('([^A-Za-z0-9 ])', '', $order->get_shipping_address_2());
    $codigo_postal = sanitizarCodigoPostal($order->get_shipping_postcode());
    $localidad =  $order->get_shipping_city();
    
    $obs_extra = '';
    if(isset($origen_datos['ppc']) && $origen_datos['ppc'] === true){

        $code_id_ppc = isset($origen_datos['ppc_datos']['id_ppc']) ? $origen_datos['ppc_datos']['id_ppc'] : 123;
        $direccion = $origen_datos['ppc_datos']['direccion'];
        $codigo_postal = sanitizarCodigoPostal($origen_datos['ppc_datos']['codigo_postal']);
        $localidad = $origen_datos['ppc_datos']['prov_codigo'];
        $provincia = $origen_datos['ppc_datos']['provincia'];

        if(isset($origen_datos['ppc_datos']['prov_codigo'])){
            $obs_extra = "Punto de retiro ".  $origen_datos['ppc_datos']['prov_codigo'];
        }

    } else {
        $provincia = WC()->countries->get_states($order->get_shipping_country())[$order->get_shipping_state()];
    }

    $numeracion = substr($origen_datos['numeracion'], 0, 2);
    $seguimiento = $order->get_id();
    $data['data']['domicilio']['direccion'] = $direccion;
    $data['data']['domicilio']['altura'] = "";
    $data['data']['domicilio']['piso'] = "";
    $data['data']['domicilio']['departamento'] = "";
    $data['data']['domicilio']['codigoPostal'] = $codigo_postal;
    $data['data']['domicilio']['localidad'] = $localidad;
    $data['data']['domicilio']['provincia'] = $provincia;
    $data['data']['domicilio']['latitud'] = "";
    $data['data']['domicilio']['longitud'] = "";
    $data['data']['domicilio']['telefono'] = $order->get_billing_phone();
    $data['data']['domicilioAlternativo']['direccion'] = $direccion;
    $data['data']['domicilioAlternativo']['altura'] = "";
    $data['data']['domicilioAlternativo']['piso'] = "";
    $data['data']['domicilioAlternativo']['departamento'] = "";
    $data['data']['domicilioAlternativo']['codigoPostal'] = $codigo_postal;
    $data['data']['domicilioAlternativo']['localidad'] = $localidad;
    $data['data']['domicilioAlternativo']['provincia'] = $provincia;
    $data['data']['domicilioAlternativo']['latitud'] = "";
    $data['data']['domicilioAlternativo']['longitud'] = "";
    $data['data']['domicilioAlternativo']['telefono'] = $order->get_billing_phone();
    $data['data']['datoNumerico'] = prefix($seguimiento,$numeracion);
    $data['data']['codigoSeguimiento'] = prefix($seguimiento,$numeracion);
    $data['data']['modeloSms'] = "";
    $data['data']['modeloEmail'] = "";
    if ($order->get_payment_method() == 'cod') {
        $data['data']['servicio'] = "B";
    } else {
        $data['data']['servicio'] = "E";
    }
    if(!is_null($code_id_ppc)){
        $data['data']['servicio'] = "F";

        if($contrareembolso > 0)
            $data['data']['servicio'] = "G";
    }
    $data['data']['marcaDeAgua'] = "";
    $data['data']['remito'] = "";
    $data['data']['observaciones'] = array(
        preg_replace('([^A-Za-z0-9 ])', '', $order->get_customer_note()),
        $obs_extra
    );
    return $data;
}


/**
 * Hook para agregar el campo bulto a la página de order list de WooCommerce y gestionar las columnas
 */
add_action('load-edit.php', 'wco_load', 20);

function wco_load() {
    $screen = get_current_screen();
    if (!isset($screen->post_type) || 'shop_order' != $screen->post_type) {
        return;
    }
    //* Agregar la columna personalizada a la tabla de lista existente (LEGACY)
    add_filter("manage_{$screen->id}_columns", 'wco_add_columns');

    //* Visualización de contenido en la columna personalizada (LEGACY)
    add_action( "manage_{$screen->post_type}_posts_custom_column", 'wco_column_cb_data', 10, 2 );
}


/**
 * Hook para Mostrar y Ordenar la columnas
 * tanto para HPOS como para LEGACY
 */
add_filter('manage_woocommerce_page_wc-orders_columns', 'wco_add_columns'); // (HPOS)

// Funcion para agregar columnas
function wco_add_columns( $columns ) {

    //$actions = $columns['order_actions'];
    $order_total = $columns['order_total'];
    $order_date = $columns['order_date'];

    // Borramos la columnas temporalmente
    unset($columns['order_date']);
    unset($columns['order_total']);
    unset($columns['order_actions']);

    // Añadimos las columnas
    $columns["bultos"] = __( "Bultos", "themeprefix");
    $columns["urbano"] = __( "Urbano", "themeprefix");
    $columns["etiqueta"] = __( "Etiqueta", "themeprefix");
    $columns['order_date'] = $order_date;
    $columns['order_total'] = $order_total;

    return $columns;

}


/**
 * Hook para mostrar el input de bultos y los links de Etiqueta y Codigo de Seguimiento en el listado de Ordenes
 */
add_action('manage_woocommerce_page_wc-orders_custom_column', 'wco_column_cb_data', 10, 2); // (HPOS)

function wco_column_cb_data( $colname, $order_id ) {

    // Traemos el Origen datos
    $order = wc_get_order( $order_id );
    $cli_codigo = str_pad($order->get_id(),10, "0", STR_PAD_LEFT);

    $origen_datos_serializado = $order->get_meta('_origen_datos_uea');
    if (!$origen_datos_serializado) {
        $origen_datos_serializado = $order->get_meta('_origen_datos');
    }

    $origen_datos = json_decode($origen_datos_serializado, true);
    $endpoint = isset($origen_datos[0]['endpoint']) ? $origen_datos[0]['endpoint'] : '';

    // Si el shipper es WARE NO puede setear la Cantidad de Bultos
    $modo_envio = isset($origen_datos[0]['modo_envio']) && $origen_datos[0]['modo_envio'] === 'ware' ? false : true;

    // Preguntamos si pertenece la columna a Bultos y si auto impacto es igual a false
    $bultosEnviado = $order->get_meta('_bultos');
    $pedidoEnviado = $order->get_meta('_pedido_enviado');
    $numeracion = $order->get_meta('_numeracion') ? $order->get_meta('_numeracion') : "";
    $numeracion = substr($numeracion, 0,1);
    $bultos = $bultosEnviado? $bultosEnviado : 1;

    // Deshabilitar input en caso que se haya enviado o no pertenece
    $disable = (!$endpoint || $pedidoEnviado || !$modo_envio) ? 'readonly' : '';

    $type = $endpoint ? 'type="number"' : '';
    $codigo_seguimiento = prefix($cli_codigo,$numeracion);
    $seguimiento = $endpoint . "cespecifica/?shi_codigo=" . str_pad((isset($origen_datos[0]['api_user']) ? $origen_datos[0]['api_user'] : ''), 6, "0", STR_PAD_LEFT) . "&cli_codigo=" . $codigo_seguimiento;
    $etiqueta = $endpoint . "impresionEtiqueta/?tipo=A4&shipper=" . str_pad((isset($origen_datos[0]['api_user']) ? $origen_datos[0]['api_user'] : ''), 6, "0", STR_PAD_LEFT) . "&codSeguimiento=" . $codigo_seguimiento;
    
    // Creamos las columnas los input y urbano
    // Solo mostramos los links a la etiqueta y al tracking cuando _origen_datos_uea tiene datos
    if (!empty($origen_datos)) {
        
            // Muestra el Input de Bultos si Tiene generado "_origen_datos_uea" y si "modo_envio" = FALSE = CROSS
            if ($colname == 'bultos' && $endpoint && $modo_envio) {
                echo "<a href='javascript:void(0)'><input name='bultos[$order->id]' style='width:65px;text-align:center' $disable href='#' min='1' value='" . esc_attr($bultos) ."' $type /></a>";
            }

            if($colname == 'urbano'){
                if ($pedidoEnviado){
                    echo "<a href='".esc_url($seguimiento) ."' target=_blank><h4 class='dashicons-before dashicons-location'>" . esc_html($codigo_seguimiento) . "</h4></a>";
                }
            }

        if ($colname == 'etiqueta' && $pedidoEnviado) {
            echo "<a href='" . esc_url($etiqueta) . "' target=_blank><h4 class='dashicons-before dashicons-text-page'>Imprimir</h4></a>";
        }
    }
/*
    ?>
    <script type="text/javascript">
        var $ = jQuery.noConflict();
        jQuery('body').on('click', '#generar-uea',function(e){
            e.preventDefault();
            $('#generar-uea-a').click();
            let data = {
                'action': 'print_urbano_ticket',
                'id':'<? echo $post->ID ?>'
            };
            jQuery.post(ajaxurl, data, function(response) {
                $('#info_print').html('Etiqueta impresa el ' + response);
            });
        });
        jQuery('body').on('click', '#tracking-uea',function(e){
            e.preventDefault();
            $('#tracking-uea-a').click();
        });
    </script>
    <?php */
}


/**
 * Hook para Visualizar la Etiqueta y el Tracking dentro de los detalles de las ordenes que son de Urbano
 */
add_action( 'woocommerce_admin_order_data_after_order_details', 'wco_add_urbano_block_after_details' );

function wco_add_urbano_block_after_details( $order ) {
    echo wco_display_order_links_block( $order );
}

function wco_display_order_links_block( $order ) {

    $cli_codigo = str_pad($order->get_id(), 10, "0", STR_PAD_LEFT);

    $origen_datos_serializado = $order->get_meta('_origen_datos_uea');
    if (!$origen_datos_serializado) {
        $origen_datos_serializado = $order->get_meta('_origen_datos');
    }

    $origen_datos = json_decode($origen_datos_serializado, true);
    $endpoint = isset($origen_datos[0]['endpoint']) ? $origen_datos[0]['endpoint'] : '';

    $pedidoEnviado = $order->get_meta('_pedido_enviado');
    $numeracion = $order->get_meta('_numeracion') ? $order->get_meta('_numeracion') : "";
    $numeracion = substr($numeracion, 0, 1);
    $codigo_seguimiento = prefix($cli_codigo, $numeracion);
    $seguimiento = $endpoint . "cespecifica/?shi_codigo=" . str_pad((isset($origen_datos[0]['api_user']) ? $origen_datos[0]['api_user'] : ''), 6, "0", STR_PAD_LEFT) . "&cli_codigo=" . $codigo_seguimiento;
    $etiqueta = $endpoint . "impresionEtiqueta/?tipo=A4&shipper=" . str_pad((isset($origen_datos[0]['api_user']) ? $origen_datos[0]['api_user'] : ''), 6, "0", STR_PAD_LEFT) . "&codSeguimiento=" . $codigo_seguimiento;

    $chosen_shipping_uea = $order->get_meta('_chosen_shipping_uea');

    $output = '';

    if ($chosen_shipping_uea === 'uea_ueforwoocom') {

        $output .= '<div class="notice notice-success" style="padding: 15px;">'; // Añadimos padding al contenedor general

        if (!empty($origen_datos) && $pedidoEnviado) {

            $output .= '<div style="display: flex; align-items: center; gap: 20px;">'; // Contenedor flex para los bloques

            // Bloque Logística
            $output .= '<div style="display: flex; flex-direction: column; align-items: center; border: 1px solid #ccc; padding: 10px; border-radius: 5px; width: 150px;">';
            $output .= '<img src="' . esc_url(plugins_url( 'urbano-argentina/includes/img/urbano_icono_plugin.jpg' )) . '" style="width: 50px; margin-bottom: 5px;">';
            $output .= '<span style="font-size: 0.9em; color: #777;">Envío por Urbano</span>';
            $output .= '</div>';

            // Bloque Seguimiento
            $output .= '<a href="' . esc_url($seguimiento) . '" target="_blank" style="text-decoration: none; font-size: 0.95em;">';
            $output .= '<div style="display: flex; flex-direction: column; align-items: center; border: 1px solid #ccc; padding: 10px; border-radius: 5px; width: 180px; height: 60px; padding-top: 21px;">';
            $output .= '<span class="dashicons dashicons-location" style="font-size: 24px; margin-bottom: 5px;"></span>';
            $output .= '<b>' . esc_html('Seguimiento: ' . $codigo_seguimiento) . '</b>';
            $output .= '</div></a>';

            // Bloque Etiqueta
            $output .= '<a href="' . esc_url($etiqueta) . '" target="_blank" style="text-decoration: none; font-size: 0.95em;">';
            $output .= '<div style="display: flex; flex-direction: column; align-items: center; border: 1px solid #ccc; padding: 10px; border-radius: 5px; width: 180px; height: 60px; padding-top: 21px;">';
            $output .= '<span class="dashicons dashicons-text-page" style="font-size: 24px; margin-bottom: 5px;"></span>';
            $output .= '<b>' . esc_html__( 'Imprimir Etiqueta', 'tu-dominio' ) . '</b>';
            $output .= '</div></a>';

            $output .= '</div>'; // Cierre del contenedor flex

        } else {
            // Mensaje cuando no se ha impactado la orden 
            $output .= '<div style="display: flex; align-items: center; gap: 20px;">';
            $output .= '<div style="display: flex; flex-direction: column; align-items: center; border: 1px solid #ccc; padding: 10px; border-radius: 5px; width: 150px;">';
            $output .= '<img src="' . esc_url(plugins_url( 'urbano-argentina/includes/img/urbano_icono_plugin.jpg' )) . '" style="width: 50px; margin-bottom: 5px;">';
            $output .= '<span style="font-size: 0.9em; color: #777;">Envío por Urbano</span>';
            $output .= '</div>';
            $output .= '<div>';
            $orders_link = admin_url( 'edit.php?post_type=shop_order' );
            $output .= '<p><b>Debe Impactar la Orden en Urbano desde el <a href="' . esc_url( $orders_link ) . '">' . esc_html__( 'listado de órdenes', 'tu-dominio' ) . '</a> para poder Imprimir la Etiqueta y ver el Código de Seguimiento.</b></p>';
            $output .= '</div>';
            $output .= '</div>';
        }

        $output .= '</div>'; // Cierre del notice-info
    }

    return $output;
}


/**
 * Hook para Insertar El Select de PPC en el CHECKOUT
 */
add_action( 'wp_footer', 'only_urbano' );
function only_urbano() { 

    // Eliminamos el PPC seleccionado para la sección CART
    if ( is_cart() ) {
        unset($_SESSION['punto_r']);
        unset($_SESSION['id_ppc']);
    }

    if ( is_checkout() ) { ?>
        <script type="text/javascript">
        jQuery(document).ready(function () {  
            jQuery('#pick_up_locations').insertAfter( jQuery( '.woocommerce-checkout-review-order-table' ) );  
            jQuery('#pick_up_locations_field').insertAfter( jQuery( '.woocommerce-checkout-review-order-table' ) );
            jQuery('.woocommerce-pickup-fields').insertAfter( jQuery( '.woocommerce-checkout-review-order-table' ) );    
        });
        </script>
    <?php }
}



/**
 * Funcion para impactar la Orden en Urbano
 */
function curl_call($data){
    $endpoint = $data['data']['autentificacion']['endpoint'];
    error_log($endpoint);
    $params = json_encode($data['data']);
    error_log($params);
    $ch = curl_init($endpoint.'cargaCliente/');
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    $uea_response = curl_exec ($ch);
    $uea_response = json_decode($uea_response,true);
    curl_close($ch);
    return $uea_response;
}


//------------------------------------------------------------------------------------------



/**
 * Hook para Agregar el Boton "Enviar a Urbano" en el listado de Ordenes
 */
add_action('manage_woocommerce_page_wc-orders_custom_column', 'mostrar_contenido_columna_personalizada', 10, 2); //HPOS
add_action('manage_shop_order_posts_custom_column', 'mostrar_contenido_columna_personalizada', 10, 2); //LEGACY
function mostrar_contenido_columna_personalizada($column, $order_id) {

    if ($column !== 'urbano') {
        return;
    }

    $order = wc_get_order($order_id);
    if (!$order) {
        return;
    }

    // Obtener el método de envío elegido
    $shipping_methods = $order->get_shipping_methods();
    $selected_shipping = reset($shipping_methods);
    $shipping_method = $selected_shipping ? $selected_shipping->get_method_id() : '';

    $pedidoEnviado = $order->get_meta('_pedido_enviado');
    $bultosEnviado = $order->get_meta('_bultos');
    $bultos = $bultosEnviado ? $bultosEnviado : 1;

    $origen_datos = $order->get_meta('_origen_datos_uea');
    
    if (!$origen_datos) {
        $origen_datos = $order->get_meta('_origen_datos');
    }
    
    error_log("order_id=".$order_id);
    error_log("origen_datos=".print_r($origen_datos,true));
    if ($origen_datos) {

        $origen_datos = json_decode($origen_datos, true);

         if (is_array($origen_datos) && isset($origen_datos[0]) && 
             is_array($origen_datos[0]) && isset($origen_datos[0]["endpoint"])) {

            $endpoint = $origen_datos[0]["endpoint"];

            if (!$pedidoEnviado && isset($endpoint)) {

                $boton_enviar_a_urbano = '<div style="display: flex; flex-direction: column; align-items: center; background-color: white; border-radius: 5px; width: 85px;">';
                $boton_enviar_a_urbano .= '<img src="' . esc_url(plugins_url( 'urbano-argentina/includes/img/urbano_icono_plugin.jpg' )) . '" style="width: 42px; margin-bottom: 4px; margin-top: 4px;">';
                $boton_enviar_a_urbano .= '<span style="font-size: 0.9em; color: #777;">Enviar a Urbano</span>';
                $boton_enviar_a_urbano .= '</div>';

                echo '<button type="button" href="#" id="enviar_a_urbano_individual" style="padding: 2px;" data-order-id="' . esc_attr($order->id) . '">' . $boton_enviar_a_urbano . '</button>';
            }
        }

    }

    /*
     * Muestra el Boton de Re-Generar Orden
     * cuando quedó el "_pedido_enviado" en TRUE para volver a generar el campo "_origen_datos_uea"
     * y asi poder generar el impacto correctamente en Urbano y obtener la etiqueta y el seguimiento
     */
    if (!isset($endpoint)) {

        /**
         * Solo mostramos el boton de "RE-GENERAR ORDEN" cuando "_origen_datos_uea" NO Existe para esa Orden o está Vacío
         * y cuando $shipping_method es "uea_ueforwoocom"
         */
        $origen_datos_uea = $order->get_meta('_origen_datos_uea');

        if (empty($origen_datos_uea) /* && $shipping_method === "uea_ueforwoocom" */) { // Habilitamos el Re-Generar Orden para todos los medios de envio
            $url = admin_url('admin.php?page=regenerar-orden&order_id=' . $order->id);
            echo '<a href="' . esc_url($url) . '" class="button button-secondary">Re-Generar</a>';
        }
    }
}



/**
 *  Funcion para obtener dimensiones y peso del pedido
 */ 
function obtener_dimensiones_uea($order) {

    $items = $order->get_items();
    $dimension_multi = 1; // Factor multiplicador de dimensión
    $weight_multi = 1;    // Factor multiplicador de peso

    // Configuración de unidades desde WooCommerce
    $dimension_unit = esc_attr(get_option('woocommerce_dimension_unit'));
    $weight_unit = esc_attr(get_option('woocommerce_weight_unit'));

    // Ajuste de multiplicadores según las unidades configuradas
    switch ($dimension_unit) {
        case 'cm':
            $dimension_multi = 0.01; // Convertir centímetros a metros
            break;
        case 'mm':
            $dimension_multi = 0.001; // Convertir milímetros a metros
            break;
        default:
            $dimension_multi = 1; // Si ya está en metros, mantener en 1
            break;
    }

    switch ($weight_unit) {
        case 'g':
            $weight_multi = 0.001; // Convertir gramos a kilogramos
            break;
        case 'kg':
            $weight_multi = 1; // Mantener en kilogramos
            break;
        default:
            $weight_multi = 1; // Asumir kilogramos si la unidad es desconocida o no especificada
            break;
    }
    
    // Inicialización de los valores
    $uea_lenth   = 0;
    $uea_width   = 0;
    $uea_height  = 0;
    $uea_weightb = 0;
    $uea_amount  = 0;

    // Recorrer cada ítem del pedido
    foreach ($items as $item) {

        $product = $item->get_product();

        if ($product) {
            
            // Obteniendo dimensiones del producto, en caso que esten en cero queda en cero y no multiplica por la unidad configurada
            $length = ($product->get_length() > 0) ? $product->get_length() * $dimension_multi : 0;
            $width  = ($product->get_width()  > 0) ? $product->get_width()  * $dimension_multi : 0;
            $height = ($product->get_height() > 0) ? $product->get_height() * $dimension_multi : 0;

            // Obteniendo el peso del producto, en caso que esten en cero queda 1 y no multiplica por la unidad configurada
            $weight = ($product->get_weight() > 0) ?  $product->get_weight() * $weight_multi : 1;

            // Suma acumulativa
            $uea_lenth   += $length;
            $uea_width   += $width;
            $uea_height  += $height;
            $uea_weightb += $weight;
            $uea_amount  += $item->get_quantity();
        }
    }

    return [
        'uea_lenth' => $uea_lenth,
        'uea_width' => $uea_width,
        'uea_height' => $uea_height,
        'uea_weightb' => $uea_weightb,
        'uea_amount' => $uea_amount,
    ];
}



/**
 * Pantalla de Re-Generación de la Orden
 * (re-genera el campo "_origen_datos_uea" e impacta la orden en Urbano si aún no existe)
 */
add_action('admin_menu', 'uea_add_admin_page');

function uea_add_admin_page() {
    add_submenu_page(   
        null,         // No muestra el Link en el Menú Lateral Izq
        'Re-Generar Orden', // Título de la página
        'Re-Generar Orden', // Título del menú
        'manage_options',   // Capacidad
        'regenerar-orden',  // Slug de la página
        'uea_regenerar_orden_callback' // Callback que muestra el contenido
    );
}

function uea_regenerar_orden_callback() {

    $order_id = isset($_GET['order_id']) ? intval($_GET['order_id']) : 0; // Obtener ID de la orden

    $order = wc_get_order($order_id); // Obtener el objeto de la orden

    if (!$order) {
        echo '<div class="error"><p>Orden no encontrada.</p></div>';
        return;
    }

    $bultos_form = $_POST['bultos_form'] ?? 1; // Obtener bultos del formulario o default a 1 si no se envió

    // Si el formulario se envió, usa el valor del formulario, sino usa el valor guardado (si existe) o 1
    $bultos = isset($_POST['regenerar_pedido']) ? $bultos_form : (!empty($bultos_orden) ? $bultos_orden : 1);

    // Procesar el formulario si se envió
    $metodo_envio = '';
    if (isset($_POST['regenerar_pedido']) && isset($_POST['metodo_envio'])) {

        // Sanitizamos el medio de envio
        $metodo_envio = sanitize_text_field($_POST['metodo_envio']);
    
        // Llama a la función para procesar la regeneración del pedido
        procesar_regeneracion_pedido($order_id, $bultos_form, $metodo_envio);

    }
    ?>
    <div class="wrap">
        <h1>Re-Generar Orden</h1><br/>
        <h2 style="color: #3c434a;">En ésta seccion podrá Re Generar una órden e impactarla directamente con Urbano Express Argentina.</h2><br/><br/>
        <form method="post" id="miFormulario" style="max-width: 400px; margin: 0 auto; padding: 20px; border: 1px solid #ccc; border-radius: 5px; background-color: #f9f9f9;" >
            <div style="display: flex; flex-direction: column; align-items: center; border: 1px solid #ccc; padding: 10px; border-radius: 5px; background-color: white;">
                <img src="../wp-content/plugins/urbano-argentina/includes/img/urbano_icono_plugin.jpg" style="width: 50px; margin-bottom: 5px;">
                <span style="font-size: 0.9em; color: #777;">Envío por Urbano</span>
            </div>
            <br/>
            <div class="form-field">
                <label for="order_id">ID de la Orden:</label>
                <input type="hidden" name="regenerar_pedido" id="regenerar_pedido" value="true">
                <input type="text" name="order_id" id="order_id" value="<?php echo esc_attr($order_id); ?>" style="width: 100%; padding: 10px; margin-bottom: 15px; border: 1px solid #ccc; border-radius: 4px;" readonly>
            </div>
            <div class="form-field">
                <label for="bultos">Número de Bultos: (Obtenidos de la Orden) <br> (La cantidad de bultos elegida reemplazará a la de la Orden)</label>
                <input type="number" name="bultos_form" id="bultos_form" min="1" max="10" value="<?php echo esc_attr($bultos); ?>" style="width: 100%; padding: 10px; margin-bottom: 15px; border: 1px solid #ccc; border-radius: 4px;">
            </div>
            <div class="form-field">
                <label for="metodo_envio">Selecciona el Medio de Envío: <br> (Se Impactará la Orden con el Metodo de Envio seleccionado)</label>

                <?php

                    global $wpdb;

                    // Obtener el método de envío previamente guardado en la orden
                    $metodo_guardado = $order->get_meta('_chosen_shipping_uea');

                    $origen_datos_uea = $order->get_meta('_origen_datos_uea');

                    $disabled = "";

                    //Verifica si el meta dato está vacío
                    if (!empty($origen_datos_uea) || $_REQUEST['regenerar_pedido'] == true) {
                        $disabled = "disabled";
                    }

                    // Consulta para obtener los métodos de envío que contienen "woocommerce_uea_ueforwoocom"
                    $metodos_envio = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}options WHERE option_name LIKE '%woocommerce_uea_ueforwoocom%'");
                    
                    echo '<select name="metodo_envio" id="metodo_envio" style="width: 100%; padding: 10px; margin-bottom: 15px; border: 1px solid #ccc; border-radius: 4px;" required>';
                    echo '<option value="">..... Seleccione un Método de Envío .....</option>';
                    
                    foreach ( $metodos_envio as $metodo ) {

                        //Des-serializamos cada metodo de envio para obtener los datos
                        $option_name = $metodo->option_name;
                        $conf_metodo = get_option($option_name);

                        $conf_metodo_titulo = $conf_metodo['title'];
                        $conf_metodo_api_user = esc_attr( "(shipper: " . $conf_metodo['api_user'] . " )" );

                        // Marcar como seleccionado si coincide con el método guardado
                        $selected = ("uea_ueforwoocom" === $metodo_guardado) ? 'selected="selected"' : '';

                        //Des-Habilitamos las disableds
                        if ($conf_metodo['enabled'] == "yes") {
                            echo '<option value="' . $option_name . '" ' . $selected . '>' . $conf_metodo_titulo . " - " . $conf_metodo_api_user ." - " . $option_name . '</option>';
                        }
                    
                    }
                     
                    echo "</select>"; 
                ?>

            </div>
            <div style="width: 100%; text-align: center;"> 
                <a href="admin.php?page=wc-orders" class="button boton-gris-especial">Cancelar y Volver</a>&nbsp;
                <button <?=$disabled?> type="button" id="button_submit" class="button boton-cerrar-especial" style="width: 125px;">Re-Generar</button>
            </div>
            </form>
    </div>

    <!-- Modal de Consentimiento de Re-Generacion de la orden -->
    <div id="modalConfirmacion" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background-color: white; border: 1px solid #ccc; padding: 20px; z-index: 1000;">
            <img src="<?php echo plugins_url('urbano-argentina/includes/img/urbano_icono_plugin.jpg'); ?>" style="width: 50px; margin-bottom: 10px;">
            <p style="font-size: 1.5em; margin-bottom: 15px;">
                Está a punto de Re-Generar la Órden para Impactarla en Urbano Express Argentina <br/>
                Independientemente del metodo elegido por el cliente. <br/><br/>
                Ésta accion es bajo su consentimiento <br/>
                ¿Estás seguro de que deseas re-generar esta orden?</p><br/>
            <button id="cancelarRegeneracion" class="button">No, Cancelar</button>
            <button id="confirmarRegeneracion" class="button button-primary">Sí, Re-Generar</button>
        </div>

        <div id="overlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.5); z-index: 999;"></div>


    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const submitButton = document.getElementById('button_submit');
        const modal = document.getElementById('modalConfirmacion');
        const form = document.getElementById('miFormulario');
        const metodoEnvio = document.getElementById('metodo_envio');

        submitButton.addEventListener('click', function() {

            // Validar si el método de envío está seleccionado
            if (metodoEnvio.value === "") {
                alert("Debe seleccionar un Método de Envío para continuar.");
                return;
            }

            overlay.style.display = 'block';
            modal.style.display = 'block';
            event.preventDefault(); // Evitar envío directo del formulario
        });

        document.getElementById('cancelarRegeneracion').addEventListener('click', function() {
            modal.style.display = 'none';
            overlay.style.display = 'none';
        });

        document.getElementById('confirmarRegeneracion').addEventListener('click', function() {
            modal.style.display = 'none';
            overlay.style.display = 'none';
            form.submit();
        });
    });
    </script>

    
    <?php
}


function uea_regenerar_orden_button() {
    $url = admin_url('admin.php?page=regenerar-orden'); // Cambia el slug si es diferente
    echo '<a href="' . esc_url($url) . '" class="button">Re-Generar</a>';
}



/*
*  Re-Genera la orden 
* - setea el campo _pedido_enviado en FALSE para poder volver a enviar la orden
* - setea el campo _bultos con lo que viene del form de Re-Generacion de la orden
* - chequea que la orden NO EXISTA en Urbano para enviarla
*/
add_action('admin_post_procesar_regeneracion_pedido', 'procesar_regeneracion_pedido');
function procesar_regeneracion_pedido() {

    if (isset($_POST['order_id'])) {
        
        $order_id = intval($_POST['order_id']);
        
        $order = wc_get_order($order_id);

        if (!$order) {
            wp_die('Orden no encontrada.');
        }

        $metodo_envio = sanitize_text_field($_POST['metodo_envio'] ?? '');
        $bultos_form = intval($_POST['bultos_form'] ?? 1);
        $regenerar_pedido = isset($_POST["regenerar_pedido"]);

        // Obtenemos las dimensiones de los productos de la orden
        $dimensiones_uea = obtener_dimensiones_uea($order);

        // Obtenemos la configuracion del metodo de envio seleccionado
        $confPlugin = get_option($metodo_envio);

        $endpoint     = $confPlugin['endpoint'] ?? '';
        $api_user     = $confPlugin['api_user'] ?? '';
        $api_password = $confPlugin['api_password'] ?? '';
        $numeracion   = $confPlugin['numeracion'] ?? '';

        $cli_codigo = str_pad($order->get_id(),10, "0", STR_PAD_LEFT);

        // Crear el array con los valores necesarios
        $_origen_datos_uea_regenerado = [
            "api_user"         => $api_user,
            "api_password"     => $api_password,
            "porcentaje_iva"   => $confPlugin['porcentaje_iva'] ?? '',
            "modo_envio"       => $confPlugin['modo_envio'] ?? '',
            "listado_ppc"      => $confPlugin['listado_ppc'] ?? '',
            "contrareembolso"  => (isset($confPlugin['contrareembolso']) && $confPlugin['contrareembolso'] === 'yes'),
            "declarado"        => $confPlugin['declarado'] ?? '',
            "uea_lenth"        => $dimensiones_uea['uea_lenth'] ?? '',
            "uea_width"        => $dimensiones_uea['uea_width'] ?? '',
            "uea_height"       => $dimensiones_uea['uea_height'] ?? '',
            "uea_amount"       => $dimensiones_uea['uea_amount'] ?? '',
            "uea_weightb"      => $dimensiones_uea['uea_weightb'] ?? '',
            "auto_impacto"     => $confPlugin['auto_impacto'] ?? '',
            "bultos_orden"     => $bultos_form,
            "envio_gratis"     => (isset($confPlugin['envio_gratis']) && $confPlugin['envio_gratis'] === 'yes'),
            "costo_fijo"       => $confPlugin['costo_fijo'] ?? '',
            "numeracion"       => $numeracion,
            "endpoint"         => $endpoint,
            "ppc_active"       => (isset($confPlugin['ppc_active']) && $confPlugin['ppc_active'] === 'yes'),
            "redondear_total"  => (isset($confPlugin['redondear_total']) && $confPlugin['redondear_total'] === 'yes')
        ];

        // Convertir el array a JSON en formato de array y en una sola línea
        $json_origen_datos_uea = wp_json_encode([$_origen_datos_uea_regenerado], JSON_UNESCAPED_SLASHES);

        // Comprobar si se hizo clic en el botón de "Re-Generar"
        if ($regenerar_pedido && $order_id) {
    
            /*
            * Actualizar el campo "_pedido_enviado" a FALSE para volver a enviarlo,
            * Ya que para impactar el pedido en urbano chequea que este campo sea FALSE
            */ 
            $order->update_meta_data('_pedido_enviado', 'false');
    
            // Actualizar el campo _bultos con lo que viene del Form de Re-Generación de la Orden
            $order->update_meta_data('_bultos', $bultos_form);
    
            $order->update_meta_data('_origen_datos_uea', $json_origen_datos_uea);

            $order->update_meta_data('_chosen_shipping_uea', 'uea_ueforwoocom');

            $order->update_meta_data('_estado_uea', $order->get_status());

            $order->save_meta_data(); // Guardar los meta datos con HPOS

            // Impacta la orden en Urbano
            $impacto_mensaje = impacta_pedido( $order_id, true, $bultos_form); // true si quieres forzar la actualización

            if (is_array($impacto_mensaje) && isset($impacto_mensaje['codError']) && $impacto_mensaje['codError'] == 0) {

                //Link de Etiqueta y Cod de Seguimiento
                $codigo_seguimiento = prefix($cli_codigo, $numeracion);
                $seguimiento = $endpoint."cespecifica/?shi_codigo=".str_pad($api_user, 6, "0", STR_PAD_LEFT)."&cli_codigo=".$codigo_seguimiento;
                $etiqueta = $endpoint."impresionEtiqueta/?tipo=A4&shipper=".str_pad($api_user, 6, "0", STR_PAD_LEFT)."&codSeguimiento=".$codigo_seguimiento;

                

                // Ejemplo de salida para verificar que se recibió correctamente
                echo '<div class="notice notice-success fade" style="display: flex; align-items: center; padding: 15px; position: relative;">';
                echo '<div style="display: flex; align-items: center; gap: 20px;">
                        <div style="display: flex; flex-direction: column; align-items: center; border: 1px solid #ccc; padding: 10px; border-radius: 5px; width: 150px;">
                            <img src="' . plugins_url('urbano-argentina/includes/img/urbano_icono_plugin.jpg') . '" style="width: 50px; margin-bottom: 5px;">
                            <span style="font-size: 0.9em; color: #777;">Envío por Urbano</span>
                        </div>';
                

                if (isset($seguimiento)) {
                    echo '<a href="' . esc_url($seguimiento) . '" target="_blank" style="text-decoration: none; font-size: 0.95em;">';
                    echo '<div style="display: flex; flex-direction: column; align-items: center; border: 1px solid #ccc; padding: 10px; border-radius: 5px; width: 180px; height: 60px; text-align: center; padding-top: 21px;">';
                    echo '<span class="dashicons dashicons-location" style="font-size: 24px; margin-bottom: 5px;"></span>';
                    echo '<b>' . esc_html('Seguimiento: ' . $codigo_seguimiento) . '</b>';
                    echo '</div></a>';
                }
                

                if (isset($etiqueta)) {
                    echo '<a href="' . esc_url($etiqueta) . '" target="_blank" style="text-decoration: none; font-size: 0.95em;">';
                    echo '<div style="display: flex; flex-direction: column; align-items: center; border: 1px solid #ccc; padding: 10px; border-radius: 5px; width: 180px; text-align: center; height: 60px; padding-top: 21px;">';
                    echo '<span class="dashicons dashicons-text-page" style="font-size: 24px; margin-bottom: 5px;"></span>';
                    echo '<b>' . esc_html__( 'Imprimir Etiqueta', 'tu-dominio' ) . '</b>';
                    echo'</div></a>';
                }         
                
                echo '<p style="margin-left: 20px; width: 40%;"><b>' . esc_html($impacto_mensaje['message']) . '</b></p>';

                echo '<p style="margin-left: 20px;"><b><?php echo esc_html($message); ?></b></p>
                        <div style="position: absolute; bottom: 10px; right: 10px;">
                            <a class="button boton-cerrar-especial" href="' . admin_url('edit.php?post_type=shop_order') .'">Volver a Listado de Pedidos</a>&nbsp;
                        </div>
                      </div>';
                echo '</div></div>';
                
            } else {

                echo '<div class="notice notice-error fade" style="display: flex; align-items: center; padding: 15px; position: relative;">
                        <div style="display: flex; flex-direction: column; align-items: center; border: 1px solid #ccc; padding: 10px; border-radius: 5px;">
                            <img src="' . esc_url(plugins_url( 'urbano-argentina/includes/img/urbano_icono_plugin.jpg' )) . '" style="width: 50px; margin-bottom: 5px;">
                        </div>
                        <p style="margin-left: 20px;"><b>' . $impacto_mensaje['message'] . '</b></p>
                        <div style="position: absolute; bottom: 10px; right: 10px;">
                            <button type="button" class="button boton-cerrar-especial" onclick="window.location.href = ' . admin_url('edit.php?post_type=shop_order') .';">Volver a Listado de Pedidos</button>&nbsp;
                        </div>
                    </div>';

            }
        
        } else {
            // redirect al listado de Pedidos
            wp_redirect(admin_url('edit.php?post_type=shop_order'));
            exit;
        }

    } else {
        // redirect al listado de Pedidos
        wp_redirect(admin_url('edit.php?post_type=shop_order'));
        exit;
    }
    
}


add_action('admin_notices', 'agregar_script_notificacion');
// Agrega el script JavaScript para manejar la solicitud AJAX
function agregar_script_notificacion() {

    // LEGACY: post_type == 'shop_order' || HPOS: page == 'wc-orders' 
    if (isset($_GET['post_type']) && $_GET['post_type'] == 'shop_order' || (isset($_GET['page']) && $_GET['page'] == 'wc-orders')) {
        wp_enqueue_script('jquery');
        ?>
            <script>
                jQuery(document).ready(function($) {
                    $("#enviar_a_urbano_individual").on("click", function(event) {

                        mostrarLoadingUrbano();

                        event.preventDefault();

                        var $button = $(this);
                        var order_id = $button.data("order-id");
                        var bultos = $("input[name=\"bultos[" + order_id + "]\"]").val(); // Obtén el valor de bultos                   

                        if (!$button.data("click-processed")) {
                            $button.data("click-processed", true); // Marcar el botón como procesado para evitar clics adicionales
                            $.ajax({
                                url: ajaxurl,
                                type: "POST",
                                data: {
                                    action: "obtener_mensaje_personalizado",
                                    order_id: order_id,
                                    bultos: bultos // Envía el valor de bultos  
                                },
                                success: function(mensaje) {

                                    ocultarLoadingUrbano();

                                    var status = mensaje.status;
                                    var message = mensaje.message;

                                    $(".wrap h1").after(`<div class="notice notice-` + status + ` fade is-dismissible" style="display: flex; align-items: center; padding: 15px;">
                                                            <div style="display: flex; flex-direction: column; align-items: center; border: 1px solid #ccc; padding: 10px; border-radius: 5px;">
                                                                <img src="../wp-content/plugins/urbano-argentina/includes/img/urbano_icono_plugin.jpg" style="width: 50px; margin-bottom: 5px;">
                                                            </div>
                                                            <p style="margin-left: 20px;"><b>` + message + `</b></p>
                                                        </div>`);

                                    // Si el impacto fue positivo recargo la pantalla para mostrar la Etiqueta y el CodSeguimiento
                                    if (status === 'success') {
                                        setTimeout(function() {
                                            location.reload();
                                        }, 3000);
                                    }

                                }
                            });
                        }
                    });
                });
            </script>
            <?php
    }
}


// Agrega la función que responderá a la solicitud AJAX
function obtener_mensaje_personalizado_ajax() {

    $order_id = $_POST['order_id'];
    $bultos = $_POST['bultos'] ?? [];
    $mensaje = obtener_mensaje_personalizado($order_id, $bultos);

    wp_send_json($mensaje); // Envía la respuesta como JSON

    wp_die(); // Termina la ejecución de WordPress

}


add_action('wp_ajax_obtener_mensaje_personalizado', 'obtener_mensaje_personalizado_ajax');
add_action('wp_ajax_nopriv_obtener_mensaje_personalizado', 'obtener_mensaje_personalizado_ajax');
// Define la función obtener_mensaje_personalizado
function obtener_mensaje_personalizado($order_id, $bultos) {

    // Implementa la lógica para obtener el mensaje personalizado
    $impacta = impacta_pedido($order_id, true, $bultos);

    return $impacta;

}


/**
 * Función para impactar un pedido en Urbano, compatible con HPOS y Legacy.
 *
 * @param int|array $order_id_bulk_actions ID del pedido o array de IDs para acciones masivas.
 * @param bool      $button               Indica si la llamada se realiza desde un botón individual.
 * @param int       $bultos        Cantidad de bultos de la orden.
 * @return string|bool Mensaje de éxito/error o booleano para acciones masivas.
 */
function impacta_pedido($order_id_bulk_actions = false, $button = false, $bultos = 1){

    if($order_id_bulk_actions){ // impacto de ordenes por lote

        $order_id = $order_id_bulk_actions;
        $bultos_orden = $bultos;

    }else{ // impacto de ordenes individual

        $order_id = $_POST['id'] ?? 0; // Asegurarse de que $_POST['id'] esté definido
        $bultos_orden = (isset($_GET['bultos']) && is_numeric($_GET['bultos']) && $_GET['bultos'] > 0) ? (int)$_GET['bultos'] : null;
    }
    
    $order = wc_get_order($order_id);

    if (!$order) {
        return "Error: No se encontró la orden con ID $order_id.";
    }

    // Obtener los meta datos de la orden de forma compatible con HPOS y Legacy
    $origen_datos_uea = $order->get_meta('_origen_datos_uea');
    $origen_datos = $origen_datos_uea ?: $order->get_meta('_origen_datos');
    $origen_datos = json_decode($origen_datos,true)[0];
    
    $data = order_collect_data($order, $origen_datos);
    
    if ( $origen_datos["modo_envio"] == "cross" || !$origen_datos["modo_envio"] || !isset($origen_datos["modo_envio"]) ){
        #Recorremos el array segun la orden
        // foreach ($bultos as $bulto){
        //     # En caso de estar vacio es 1 de lo contrario es el valor indicado
        //     if ((int)$bulto[$order_id]>0){
        //         $cantidad = $bulto[$order_id];
        //     }else{
        //         $cantidad = $bultos_button ?? 1;
        //     }
        // }
        #Recorremos el array para asignarle la cantidad a la orden
        foreach ($data as $key => $value){
            $value["productos"][0]["cantidad"] = $bultos_orden;
        }
    }else{
        foreach ($data as $key => $value){
            $data['data']['productos'][0]['descripcionProducto'] = 'Pedido con id '.$order_id.' realizado a travez de WooCommerce, ware';
        }
    }

    #Asignamos al array asociativo en el array data
    $orden = array ( "data"  => $value  );
    
    $pedidoEnviado = $order->get_meta('_pedido_enviado');
    $prefix = $origen_datos["numeracion"];
    
    if($pedidoEnviado != "true"){ // Si la orden nunca fué enviada

        $uea_response = curl_call($orden);

        // Si el impacto fue positivo
        if (is_array($uea_response) && isset($uea_response['codError']) && $uea_response['codError'] === 0) {

            $order->update_meta_data('_bultos', $bultos_orden);
            $order->update_meta_data('_pedido_enviado', "true");

            if ($prefix !== null) {
                $order->update_meta_data('_numeracion', $prefix);
            }

            $order->save_meta_data(); // Guardar los meta datos con HPOS
       
            if($order_id_bulk_actions && !$button){
                return true;
            }else{

                $impacto = array (
                    'codError' => 0,
                    'status' => 'success',
                    'message' => 'El pedido con id '.$order_id.' se envio exitosamente a Urbano!'
                );

                return $impacto;
            }
                     
        } else { // Si el impacto fue negativo

            if($order_id_bulk_actions && !$button){
                return false;
            }else{

                $impacto = array (
                    'codError' => 4,
                    'status' => 'error',
                    'message' => 'El pedido con id '.$order_id.' no pudo ser impactado </br>'.
                                 'codError: '.$uea_response['codError'].' </br>'.
                                 'descError: '.$uea_response['descError'].' </br>'.
                                 'Si el problema persiste comuníquese con urbano a: <a href="mailto:integracionsistemas@urbano.com.ar">integracionsistemas@urbano.com.ar</a>'  
                );

                return $impacto;                
            }

        }

    }else{ // si la orden ya se encuentra en Urbano

        if($order_id_bulk_actions && !$button){
            return false;
        }else{
            return "Atención: ¡Este pedido con id $order_id ya se encuentra registrado en Urbano!";
        }

    }    

    return 'El pedido con id '.$order_id.' no pudo ser impactado';
}

/**
 * Hook ejecutado cuando el pago se procesa, pero aún no tenemos todos los datos completos
 */
add_action('woocommerce_checkout_payment_processed', 'checkout_order_payment_uea', 10, 1);
function checkout_order_payment_uea($order_id) {

    $order = wc_get_order($order_id);
    
    // Recuperamos el método de envío
    $shipping_methods = $order->get_shipping_methods();
    $selected_shipping = reset($shipping_methods);
    $shipping_method_id = $selected_shipping ? $selected_shipping->get_method_id() : '';

    $existing_shipping = get_post_meta($order_id, '_chosen_shipping_uea', true);
    if (!$existing_shipping || $existing_shipping != $shipping_method_id) {
        update_post_meta($order_id, '_chosen_shipping_uea', $shipping_method_id);
    }

    update_post_meta($order_id, '_estado_uea', $order->get_status());
}


/**
 * Hook ejecutado al finalizar la compra completamente
 */
add_action('woocommerce_thankyou', 'checkout_order_processed_uea', 10, 1);
function checkout_order_processed_uea($order_id) {

    if (!session_id()) {
        session_start();
    }

    $order = wc_get_order($order_id);

    // Obtener el método de envío elegido
    $shipping_methods = $order->get_shipping_methods();
    $selected_shipping = reset($shipping_methods);
    $shipping_method = $selected_shipping ? $selected_shipping->get_method_id() : '';

    // Guardar método de envío solo si es necesario
    $existing_shipping = get_post_meta($order_id, '_chosen_shipping_uea', true);
    if (!$existing_shipping || $existing_shipping != $shipping_method) {
        update_post_meta($order_id, '_chosen_shipping_uea', $shipping_method);
    }

    update_post_meta($order_id, '_estado_uea', $order->get_status());

    // Si el método de envío es exactamente "uea_ueforwoocom", guardamos el origen de datos
    if ($shipping_method === 'uea_ueforwoocom') { 
        if (!get_post_meta($order_id, '_origen_datos_uea', true) && !empty($_SESSION['origen_datos_uea'])) {
            update_post_meta($order_id, '_origen_datos_uea', $_SESSION['origen_datos_uea']);
        }
    }

    // Recuperar origen de datos si existe
    $origen_datos = get_post_meta($order_id, '_origen_datos_uea', true);
    $origen_datos = json_decode($origen_datos, true)[0] ?? [];

    if (!empty($origen_datos) && isset($origen_datos["auto_impacto"]) && $origen_datos["auto_impacto"] == "si") {
        impacta_pedido($order_id, true);
    }
}


//-------------------------------------ACCIONES EN LOTE-------------------------------------------------
/**
 * Hook para agregar "Enviar pedidos a Urbano Express Argentina" para LEGACY
 */
// add_filter( 'bulk_actions-edit-shop_order', 'proceso_lotes_bulk_actions' );
// function proceso_lotes_bulk_actions( $bulk_actions ) {
//     $bulk_actions['send_orders'] = 'Enviar pedidos a Urbano Express Argentina LEGACY';
//     $bulk_actions['print_formato'] = 'Generar etiquetas por lote';
//     return $bulk_actions;
// }


add_action( 'current_screen', 'agregar_opcion_enviar_urbano_bulk_hpos_legacy' );
function agregar_opcion_enviar_urbano_bulk_hpos_legacy( $screen ) {
   // error_log('screen RECIBIDA: ' . $screen->id);
    if ( $screen->id !== 'woocommerce_page_wc-orders' && $screen->id !== 'edit-shop_order' ) {
        return;
    }

    add_action( 'admin_print_footer_scripts', 'js_insertar_enviar_pedidos_a_urbano_por_lote', 99 );
}


/**
 * Funcion para Agregar a las acciones por lote la opcion "Enviar Pedido a Urbano"
 * compatible con HPOS y LEGACY
 */
function js_insertar_enviar_pedidos_a_urbano_por_lote() {
?>
    <script type="text/javascript">
    jQuery(document).ready(function($) {

        // Impacto
        var urbano_bulk_impact_action_data = {
            action_slug: "send_orders",
            action_label: "Enviar Pedidos por Lote (Urbano Express Argentina)"
        };

        // Impresion
        var urbano_bulk_print_action_data = {
            action_slug: "print_orders",
            action_label: "Imprimir Etiquetas por Lote (Urbano Express Argentina)"
        };

        $("select[name='action'], select[name='action2']").each(function() {

            var $select = $(this);

            // Para la acción de impacto
            if (!$select.find("option[value='" + urbano_bulk_impact_action_data.action_slug + "']").length) {
                $select.append(
                    $("<option>", {
                        value: urbano_bulk_impact_action_data.action_slug,
                        text: urbano_bulk_impact_action_data.action_label
                    })
                );
            }

            // Para la acción de impresión
            if (!$select.find("option[value='" + urbano_bulk_print_action_data.action_slug + "']").length) {
                $select.append(
                    $("<option>", {
                        value: urbano_bulk_print_action_data.action_slug,
                        text: urbano_bulk_print_action_data.action_label
                    })
                );
            }

        });


        // Accion del boton "Aplicar" del proceso por lote
        $('input#doaction, input#doaction2').on('click', function(e) {

            var $btn = $(this);
            var selected_action = ($btn.attr('id') === 'doaction')
            ? $('select[name="action"]').val()
            : $('select[name="action2"]').val();

            if (selected_action === urbano_bulk_impact_action_data.action_slug) { // Impacto por lote

                e.preventDefault(); // Evitar el envío normal del formulario

                var orders_data = [];
                // Adaptamos la selección para HPOS y LEGACY
                $('input[type="checkbox"]:checked').each(function() {
                    var $checkbox = $(this);
                    var id = '';

                    // Para HPOS: name="id[]", el ID está en el value
                    if ($checkbox.attr('name') === 'id[]') {
                        id = $checkbox.val();
                    }
                    // Para LEGACY: name="post[]", el ID está en el value
                    else if ($checkbox.attr('name') === 'post[]') {
                        id = $checkbox.val();
                    }

                    if (id) {

                        // Capturamos la cantidad de Bultos de cada orden seleccionada
                        var bultos_input = $('input[name="bultos[' + id + ']"]');
                        var bultos_value = bultos_input.val();

                        orders_data.push({
                            id: id,
                            bultos: bultos_value ? parseInt(bultos_value) : 1
                        });

                    }
                });


                if (orders_data.length > 0) {
                    
                    if(confirm('¿Estás seguro de que deseas Impactar en Urbano las ' + orders_data.length + ' Órdenes seleccionadas?')) {

                        mostrarLoadingUrbano();

                        // Llamada AJAX a tu función de procesamiento
                        $.ajax({
                            url: ajaxurl, // Variable global de WordPress para la URL de AJAX
                            type: 'POST',
                            data: {
                                action: 'procesar_lote_urbano_ajax_callback',
                                mode: 'send_orders',
                                orders_data: orders_data,
                                _ajax_nonce: '<?php echo wp_create_nonce('procesar_lote_urbano_nonce'); ?>' // Nonce de seguridad
                            },
                            success: function(response) {

                                ocultarLoadingUrbano();

                                if (response.success) {                                
                                    window.location.href = response.data.redirect_url; // Redirigir con parámetros GET
                                } else {
                                    alert('Error al procesar los pedidos success: ' + response.data.message);
                                }

                            },
                            error: function(errorThrown) {

                                ocultarLoadingUrbano();

                                alert('Error al procesar los pedidos error: ' + errorThrown);

                            }
                        });

                    }

                } else {
                    alert('Por favor, selecciona al menos un pedido.');
                }

            } else if (selected_action === urbano_bulk_print_action_data.action_slug) { // Impresion por Lote

                e.preventDefault();

                // Lógica para recopilar los IDs de los pedidos seleccionados para la impresión
                var orders_data_print = [];
                // Adaptamos la selección para HPOS y LEGACY
                $('input[type="checkbox"]:checked').each(function() {
                    var $checkbox = $(this);
                    var id = '';

                    // Para HPOS: name="id[]", el ID está en el value
                    if ($checkbox.attr('name') === 'id[]') {
                        id = $checkbox.val();
                    }
                    // Para LEGACY: name="post[]", el ID está en el value
                    else if ($checkbox.attr('name') === 'post[]') {
                        id = $checkbox.val();
                    }

                    if (id) {

                        // Capturamos la cantidad de Bultos de cada orden seleccionada
                        var bultos_input = $('input[name="bultos[' + id + ']"]');
                        var bultos_value = bultos_input.val();

                        orders_data_print.push({
                            id: id,
                            bultos: bultos_value ? parseInt(bultos_value) : 1
                        });

                    }
                });

                if (orders_data_print.length > 0) {

                    if(confirm('¿Estás seguro de que deseas Imprimir las ' + orders_data_print.length + ' Etiquetas seleccionadas?')) {
                        // Llamada AJAX para procesar la impresión en lote
                        $.ajax({
                            url: ajaxurl,
                            type: 'POST',
                            data: {
                                action: 'procesar_lote_urbano_ajax_callback', // Mantén el mismo callback PHP
                                mode: 'print_formato', // Cambia el 'mode' para identificar la acción en PHP
                                orders_data: orders_data_print,
                                _ajax_nonce: '<?php echo wp_create_nonce('procesar_lote_urbano_nonce'); ?>'
                            },
                            success: function(response) {
                                if (response.success) {
                                    window.location.href = response.data.redirect_url; // Redirigir con los resultados de la impresión
                                } else {
                                    alert('Error al procesar la impresión de etiquetas: ' + response.data.message);
                                }
                            },
                            error: function(errorThrown) {
                                alert('Error al procesar la impresión de etiquetas en Lote: ' + errorThrown);
                            }
                        });

                    }
                } else {
                    alert('Por favor, selecciona al menos un pedido para imprimir.');
                }
            }
        });
    });
    </script>
<?php
}

//para ajax de usuarios no registrados
add_action('wp_ajax_nopriv_procesar_lote_urbano_ajax_callback', 'procesar_lote_urbano_ajax_callback');

// //para ajax de usuarios registrados
add_action('wp_ajax_procesar_lote_urbano_ajax_callback', 'procesar_lote_urbano_ajax_callback');
 
function procesar_lote_urbano_ajax_callback() {
    
    check_ajax_referer('procesar_lote_urbano_nonce', '_ajax_nonce');

    $orders_data = isset($_POST['orders_data']) ? $_POST['orders_data'] : []; // <---- RECIBIMOS el array bajo la clave 'orders_data'
    
    $mode = isset($_POST['mode']) ? $_POST['mode'] : '';

    /**
     * Impresion de ordenes
     */
    if ( $mode === 'print_formato' ){

        #Recorremos el array segun la orden
        $processed_ids = array(); 
        $failed_ids = array(); 
        $success_processes_count = 0;
        $failed_processes_count = 0;
        $datos_impresion = array();

        foreach ( $orders_data as $order_id ) {

            $id = $order_id['id'];
            $bultos = isset($order_id['bultos']) ? $order_id['bultos'] : 1;

            $order = wc_get_order($id);

            $origen_datos = $order->get_meta('_origen_datos_uea');

            if ($origen_datos==false)
                    $origen_datos = $order->get_meta('_origen_datos');

            $origen_datos = json_decode($origen_datos,true)[0];

            $enviroment = $origen_datos['endpoint'] === 'https://testing-apis.urbano.com.ar/' ? 'testing-' : '';

            $pedidoEnviado = $order->get_meta('_pedido_enviado');

            $numeracion = substr($origen_datos['numeracion'], 0, 2);
            $seguimiento = $order->get_id();

            if ($pedidoEnviado) {

                $datos = [
                    'cli_codigo' => prefix($seguimiento, $numeracion),
                    'shipper' => $origen_datos['api_user'],
                    'bultos' => $bultos,
                ];

                array_push($datos_impresion, $datos);//para agregar nuevo elemento al array 

                $success_processes_count++;
                $processed_ids[] = prefix($seguimiento, $numeracion);

            } else {

                $failed_ids[] = $id;
                $failed_processes_count++;

            }

        }

        // agregamos los parámetros a la url devuelta
        $redirect_url = admin_url('edit.php?post_type=shop_order'); // URL correcta para la página de pedidos
        $redirect_url = add_query_arg(
            array(
                'print_formato' => '1',
                'ordenes2' => $datos_impresion,
                'success_processes_count2' => $success_processes_count,
                'failed_processes_count2' => $failed_processes_count,
                'processed_ids2' => implode( ',', $processed_ids ),
                'failed_ids2' => implode( ',', $failed_ids ),
                'enviroment' => $enviroment,
            ),
            $redirect_url
        );
    
        $response_data = array(
            'redirect_url' => esc_url_raw($redirect_url),
        );

        wp_send_json_success($response_data);

    } 

    /**
     * Impacto de ordenes
     */
    if ( $mode == 'send_orders') {

        // inicializamos
        $processed_ids = array(); 
        $failed_ids = array(); 
        $success_processes_count = 0;
        $failed_processes_count = 0;
        
        foreach ( $orders_data as $order_id ) {

            $id = $order_id['id'];
            $bultos = isset($order_id['bultos']) ? $order_id['bultos'] : 1;

            //enviamos el id y los bultos para impacta_pedido, y guardamos la respuesta
            if(impacta_pedido($id, false, $bultos)){
                $success_processes_count++;
                $processed_ids[] = $id;
            }else{
                $failed_ids[] = $id;
                $failed_processes_count++;
            }  
            
            error_log("failed=".print_r($failed_ids, true));
            error_log("processed=".print_r($processed_ids, true));
                      
        }

        // agregamos los parámetros a la url devuelta
        $redirect_url = admin_url('edit.php?post_type=shop_order'); // URL correcta para la página de pedidos
        $redirect_url = add_query_arg(
            array(
                'send_orders' => 'true',
                'success_processes_count' => $success_processes_count,
                'failed_processes_count' => $failed_processes_count,
                'processed_ids' => implode( ',', $processed_ids ),
                'failed_ids' => implode( ',', $failed_ids ),
            ),
            $redirect_url
        );
    
        $response_data = array(
            'redirect_url' => esc_url_raw($redirect_url),
        );

        wp_send_json_success($response_data);

    } 

    wp_die();

}


/*
 * Hook para Mostrar los resultados luego de el envío por lote
 */ 
add_action( 'admin_notices', 'proceso_lotes_bulk_action_admin_notice' );
function proceso_lotes_bulk_action_admin_notice() {

    global $pagenow;

    // Verificamos si estamos en la página de administración de pedidos de WooCommerce
    $is_woocommerce_orders_page = false;
    if ( 'edit.php' === $pagenow && isset( $_GET['post_type'] ) && 'shop_order' === $_GET['post_type'] ) { // Para HPOS
        $is_woocommerce_orders_page = true; 
        $orders_list_url = admin_url( 'edit.php?post_type=shop_order' );
    } elseif ( 'admin.php' === $pagenow && isset( $_GET['page'] ) && 'wc-orders' === $_GET['page'] ) { // Para LEGACY
        $is_woocommerce_orders_page = true; 
        $orders_list_url = admin_url( 'admin.php?page=wc-orders' );
    }

    /**
     * Mostramos resumen de Ordenes Enviadas en Lote
     */
    if ( $is_woocommerce_orders_page && isset( $_GET['send_orders'] ) ) {
        
        $success_processes_count = intval( $_REQUEST['success_processes_count'] );
        $failed_processes_count = intval( $_REQUEST['failed_processes_count'] );

        /**
         * Mostramos el mensaje de pedidos enviados correctamente
         */
        if( $success_processes_count > 0){
            $ordenes_procesadas = array();
            $ordenes_id = array();
            $orders = explode( ',' , $_GET['processed_ids']);
            foreach($orders as $order){
                $ordenes_procesadas[] = "#". $order;
            }
            printf( '<div class="notice notice-success fade is-dismissible" style="display: flex; align-items: center; padding: 15px;">
                        <div style="display: flex; flex-direction: column; align-items: center; border: 1px solid #ccc; padding: 10px; border-radius: 5px;">
                            <img src="' . esc_url(plugins_url( 'urbano-argentina/includes/img/urbano_icono_plugin.jpg' )) . '" style="width: 50px; margin-bottom: 5px;"> 
                        </div>
                        <p style="margin-left: 20px;"><b>' .
                            _n( '%s Pedido registrado en Urbano satisfactoriamente. ID Pedido ' . implode(', ' , $ordenes_procesadas),
                            '%s pedidos fueron registrados en Urbano satisfactoriamente. IDs de los Pedidos ' . implode(', ' , $ordenes_procesadas),
                            $success_processes_count,
                            'woocommerce'
                        ) . '
                        </b></p>
                        <div style="position: absolute; bottom: 10px; right: 10px;">
                            <button onclick="window.location.href = \'' . esc_url( $orders_list_url ) . '\';" class="button boton-cerrar-especial">Cerrar</button>&nbsp;
                        </div>
                    </div>', $success_processes_count );
        }

        /**
         * Si hay procesos fallidos mostramos el mensaje de error
         */
        if( $failed_processes_count > 0){
            $failed_orders = explode( ',' , $_GET['failed_ids']);
            $ordenes_no_procesadas = array();
            foreach($failed_orders as $order){
                $ordenes_no_procesadas[] = "#". $order;
            }
            printf( '<div class="notice notice-error fade" style="display: flex; align-items: center; padding: 15px; position: relative;">
                        <div style="display: flex; flex-direction: column; align-items: center; border: 1px solid #ccc; padding: 10px; border-radius: 5px;">
                            <img src="' . esc_url(plugins_url( 'urbano-argentina/includes/img/urbano_icono_plugin.jpg' )) . '" style="width: 50px; margin-bottom: 5px;"> 
                        </div>
                        <p style="margin-left: 20px;"><b>' .
                            _n( '%s pedido no pudo ser registrado en Urbano. ID de Pedido ' . implode(', ' , $ordenes_no_procesadas) ,
                            '%s pedidos no pudieron ser registrados en Urbano. IDs de los Pedidos ' . implode(', ' , $ordenes_no_procesadas),
                            $failed_processes_count,
                            'woocommerce'
                            ) . '
                        </b></p>
                        <div style="position: absolute; bottom: 10px; right: 10px;">
                            <button onclick="window.location.href = \'' . esc_url( $orders_list_url ) . '\';" class="button boton-cerrar-especial">Cerrar</button>&nbsp;
                        </div>
                    </div>', $failed_processes_count );
        }

    }

    /**
     * Mostramos opciones de impresion en Lote
     */
    if ( $is_woocommerce_orders_page && isset( $_GET['print_formato'] ) ) {

            $ordenes = $_GET['ordenes2'];
            $enviroment = $_GET['enviroment'];
            $success_processes_count2 = intval( $_REQUEST['success_processes_count2'] );
            $failed_processes_count2 = intval( $_REQUEST['failed_processes_count2'] );

            #verifica si hay procesos por lote
            if( $success_processes_count2 > 0){
                $ordenes_procesadas = array();
                $ordenes_id = null;
                $orders = explode( ',' , $_GET['processed_ids2']);

                #si hay procesos fallidos mostramos el mensaje de error
                foreach($orders as $order){

                    $ordenes_procesadas[] = "#". $order;
                    $order = preg_replace('/[^A-Za-z0-9 & =\[\]]/', '', $order);
                    $ordenes_id[] = $order;

                }

                #mostramos el boton de impresion.
                printf( '<div class="notice notice-success fade" style="display: flex; align-items: center; padding: 15px; position: relative;">
                            <div style="display: flex; flex-direction: column; align-items: center; border: 1px solid #ccc; padding: 10px; border-radius: 5px;">
                                <img src="' . esc_url(plugins_url( 'urbano-argentina/includes/img/urbano_icono_plugin.jpg' )) . '" style="width: 50px; margin-bottom: 5px;">
                            </div>
                            <p style="margin-left: 20px;">
                            <buton style="position:relative;top:2px;" onclick="porFormato();" class="boton-azul-especial" target="_blank">IMPRIMIR</buton>&nbsp;

                                <select id="formato" name="formato" data-toggle="tooltip" data-placement="top" title="Seleccione la etiqueta que Urbano imprimirá" class= data-etiqueta>
                                    <option value="A4">A4</option>
                                    <option value="Z10X10">Z10X10</option>
                                    <option value="Z10X15">Z10X15</option>
                                    <option value="Z10X6">Z10X6</option>
                                    <option value="zpl">zpl</option>
                                </select>&nbsp;
                                </p>

                                <div style="position: absolute; bottom: 10px; right: 10px;">
                                    <button onclick="window.location.href = \'' . esc_url( $orders_list_url ) . '\';" class="button boton-cerrar-especial">Cerrar</button>&nbsp;
                                </div>

                                <b>&nbsp;'.
                        _n( ' %s etiqueta por generar, seleccione el formato de impresión, ID de etiqueta ' . implode(', ' , $ordenes_procesadas),
                            '%s etiquetas por generar, seleccione el formato de impresión, ID de etiquetas ' . implode(', ' , $ordenes_procesadas),
                            ' %s Etiquetas por generar, seleccione el formato de impresión. ' ,
                            $success_processes_count2,
                            'woocommerce'
                        ) . '', $success_processes_count2 );

                #Generamos la funcion para el proceso para la url de impresion
                $shipper= $ordenes[0]['shipper'];

                ?>
                      <script>
                        function porFormato(){
                            var lote,formato;
                            formato = document.getElementById('formato');
                            var selected = formato.options[formato.selectedIndex].text;
                            const enviroment = '<?=$enviroment?>';
                            const shipper = '<?=$shipper?>';
                            const ordenesIdArray = <?php echo json_encode($ordenes_id); ?>;
                            const printPageUrl = `<?php echo site_url('/urbano-bulk-print/'); ?>?ordenes=${encodeURIComponent(ordenesIdArray.join(','))}&formato=${encodeURIComponent(selected)}&shipper=${encodeURIComponent(shipper)}&enviroment=${encodeURIComponent(enviroment)}`;
                            window.open(printPageUrl, '_blank');
                        }
                      </script>

                <?php echo "</b></p></div>";
                    #si hay procesos fallidos mostramos el mensaje de error
            }
            
            if( $failed_processes_count2 > 0){
                $failed_orders = explode( ',' , $_GET['failed_ids2']);
                $ordenes_no_procesadas = array();
                foreach($failed_orders as $order){
                    $ordenes_no_procesadas[] = "#". $order;
                }
                printf( '<div class="notice notice-error fade" style="display: flex; align-items: center; padding: 15px; position: relative;">
                            <div style="display: flex; flex-direction: column; align-items: center; border: 1px solid #ccc; padding: 10px; border-radius: 5px;">
                                <img src="' . esc_url(plugins_url( 'urbano-argentina/includes/img/urbano_icono_plugin.jpg' )) . '" style="width: 50px; margin-bottom: 5px;">
                            </div>
                            <p style="margin-left: 20px;"><b>' .
                        _n( '%s etiqueta no pudo ser generada al no ser impactada previamente, ID de etiqueta ' . implode(', ' , $ordenes_no_procesadas) ,
                        '%s etiquetas no pudieron ser generadas al no ser impactada previamente, ID de etiquetas ' . implode(', ' , $ordenes_no_procesadas),
                        $failed_processes_count2,
                        'woocommerce'
                        ) . '</b></p>
                            <div style="position: absolute; bottom: 10px; right: 10px;">
                                <button onclick="window.location.href = \'' . esc_url( $orders_list_url ) . '\';" class="button boton-cerrar-especial">Cerrar</button>&nbsp;
                            </div>
                        </div>', $failed_processes_count2 );
            }
        }
}


/**
 * Hook para Mergear los PDFs y mostrarlos
 */
function urbano_bulk_print_page() {
    if (isset($_GET['ordenes']) && isset($_GET['formato']) && isset($_GET['shipper'])) {

        $pdfCount = 0;

        require_once plugin_dir_path(__FILE__) . 'fpdf_merge.php';

        $ordenes_ids = explode(',', sanitize_text_field($_GET['ordenes']));
        $formato = sanitize_text_field($_GET['formato']);
        $shipper = sanitize_text_field($_GET['shipper']);
        $enviroment = sanitize_text_field($_GET['enviroment']);

        $pdfMerger = new FPDF_Merge();
        $tempFiles = [];
        $upload_dir = wp_upload_dir();
        $tempDir = trailingslashit($upload_dir['basedir']) . 'urbano_temp_pdf/';

        // Asegurarse de que el directorio temporal exista y tenga permisos de escritura
        if (!file_exists($tempDir)) {
            wp_mkdir_p($tempDir);
        }

        foreach ($ordenes_ids as $orden_id) {

            $pdf_url = "https://" . $enviroment . "apis.urbano.com.ar/impresionEtiqueta/?tipo=" . $formato . "&shipper=" . $shipper . "&codSeguimiento=" . $orden_id;
            $response = wp_remote_get($pdf_url);

            if (!is_wp_error($response) && wp_remote_retrieve_response_code($response) === 200) {
                $pdf_content = wp_remote_retrieve_body($response);
                $tempFileName = $tempDir . 'urbano_temp_' . $orden_id . '_' . uniqid() . '.pdf';
                $saved = file_put_contents($tempFileName, $pdf_content);

                if ($saved) {
                    $pdfMerger->add($tempFileName);
                    $tempFiles[] = $tempFileName; // Guardar la ruta para eliminar después
                    $pdfCount++;
                } else {
                    error_log("Error al guardar el PDF temporal para la orden #{$orden_id}");
                }
            } else {
                error_log("Error al obtener PDF para la orden #{$orden_id}: " . wp_remote_retrieve_response_code($response) . ' - ' . wp_remote_retrieve_body($response));
            }

        }

        // Realizar la combinación si se obtuvieron PDFs
        if ($pdfCount > 0) {

            $pdfMerger->output();

            // Eliminar los archivos temporales
            foreach ($tempFiles as $tempFile) {
                if (file_exists($tempFile)) {
                    unlink($tempFile);
                }
            }

            // Eliminar el directorio temporal si está vacío (opcional)
            $files = glob($tempDir . '*');
            if (empty($files)) {
                rmdir($tempDir);
            }

            exit;
        } else {
            echo "No se pudieron obtener las etiquetas para las órdenes seleccionadas.";
            exit;
        }
    } 

}
add_action('wp', 'urbano_bulk_print_page');

// Asegúrate de que la regla de reescritura para urbano-bulk-print/ esté activa
function urbano_bulk_print_rewrite_rule() {
    add_rewrite_rule('^urbano-bulk-print/?$', 'index.php?urbano_bulk_print=1', 'top');
}
add_action('init', 'urbano_bulk_print_rewrite_rule');

function urbano_bulk_print_query_vars($vars) {
    $vars[] = 'urbano_bulk_print';
    return $vars;
}
add_filter('query_vars', 'urbano_bulk_print_query_vars');

function urbano_bulk_print_template_include($template) {
    if (get_query_var('urbano_bulk_print')) {
        $new_template = plugin_dir_path(__FILE__) . 'templates/urbano-bulk-print-page.php';
        if (file_exists($new_template)) {
            return $new_template;
        } else {
            // Si el archivo de plantilla no existe, puedes usar una plantilla por defecto
            return get_index_template();
        }
    }
    return $template;
}
// Comenta o elimina esta línea si quieres que la función urbano_bulk_print_page() genere la salida directamente
// add_filter('template_include', 'urbano_bulk_print_template_include');

//--------------------------------------------------------------------------------------------




//----------------------------------------------------------------------
//------------------- PUNTOS DE RETIRO O SUCURSALES --------------------

/**
 * Hook para calcular el peso total de los productos
 */
add_action( 'woocommerce_before_checkout_form', 'bbloomer_print_cart_weight' );
//add_action( 'woocommerce_before_cart', 'bbloomer_print_cart_weight' );
function bbloomer_print_cart_weight() {

    if ( ! session_id() ) {
        session_start();
    }
    
   $_SESSION['peso_productos_ppc'] = WC()->cart->get_cart_contents_weight();
}


/**
 * Hook para des-habilitar la seleccion del Metodo de de Envio en el CHECKOUT
 *  Asi de esta forma SOLO permite la seleccion de dicho metodo en el CART
 */
/*add_action('wp_footer', function() {
    if (is_checkout()) {
        ?>
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                let shippingMethods = document.querySelectorAll("input[name^='shipping_method']");
                shippingMethods.forEach(method => {
                    method.disabled = true; // Deshabilitar selección
                });
            });
        </script>
        <style>
            .woocommerce-checkout #shipping_method {
                opacity: 0.6; /* Visualmente deshabilitado */
      /*          pointer-events: none;
            }
        </style>
        <?php
    }
}); */


/**
 * Hook para habilitar o des-habilitar el SELECT con las direcciones de PPC en el CHECKOUT
 */
add_action('wp_footer', function() {
    if (is_checkout()) {
        ?>
        <script>
            jQuery(function() {
                function toggleSelect() {
                    var urbanoSelected = jQuery('#shipping_method_0_uea_ueforwoocom').is(':checked');

                    if (urbanoSelected) {
                        jQuery('#pick_up_locations_field').show();
                        jQuery('#pick_up_locations').prop('disabled', false).show();
                    } else {
                        jQuery('#pick_up_locations_field').hide();
                        jQuery('#pick_up_locations').prop('disabled', true).hide();
                    }
                }

                // Verificar el estado del radio button al cargar la página
                function checkInitialShippingMethod() {
                    var urbanoSelected = jQuery('#shipping_method_0_uea_ueforwoocom').is(':checked');
                    if (urbanoSelected) {
                        jQuery('#pick_up_locations_field').show();
                        jQuery('#pick_up_locations').prop('disabled', false).show();
                    } else {
                        jQuery('#pick_up_locations_field').hide();
                        jQuery('#pick_up_locations').prop('disabled', true).hide();
                    }
                }

                // Ejecutar al cargar la página
                jQuery(document).ready(function() {
                    checkInitialShippingMethod(); // Verificar el estado al cargar

                    // Detectar cambios en los métodos de envío
                    jQuery(document).on('change', 'input[name="shipping_method[0]"]', function() {
                        toggleSelect();

                        // Si cambiamos de Envío Gratis a Urbano, forzamos la aparición del select
                        var selectedShippingMethod = jQuery('input[name="shipping_method[0]"]:checked').val();
                        if (selectedShippingMethod === 'uea_ueforwoocom') { // Aseguramos que el método Urbano esté seleccionado
                            jQuery('#pick_up_locations_field').show();
                            jQuery('#pick_up_locations').prop('disabled', false).show();
                        }
                    });

                    // Mostrar select cuando se hace click en Urbano
                    jQuery(document).on('click', '#shipping_method_0_uea_ueforwoocom', function() {
                        toggleSelect();
                    });
                });
            });
        </script>
        <?php
    }
}); 


/**
 * Hook para Mostrar los PPC en el CHECKOUT
 */
add_filter('woocommerce_checkout_fields', 'bbloomer_display_pickup_locations');
function bbloomer_display_pickup_locations($fields)
{
    // Verifica si estamos en la página de checkout
    if (!is_checkout()) {
        return $fields;
    }

    if ( ! session_id() ) {
        session_start();
    }

    // Verifica el método de envío seleccionado en CART
    $chosen_shipping_method = WC()->session->get('chosen_shipping_methods');

    $is_urbano_selected = is_array($chosen_shipping_method) && in_array('uea_ueforwoocom', $chosen_shipping_method);

    // Si el método de envío Urbano NO está seleccionado, elimina el campo de PPC
    if (!$is_urbano_selected) {
        if (isset($fields['billing']['pick_up_locations'])) {
            unset($fields['billing']['pick_up_locations']);
        }
        return $fields;
    }

    global $wp_session,$wpdb;
    $resultados= $wpdb->get_results( "SELECT option_value FROM ".$wpdb->prefix."options WHERE option_name like '%woocommerce_uea_ueforwoocom%' LIMIT 1" );
    $origen_datos = unserialize($resultados[0]->option_value);

    //error_log("oriden_datos=".print_r($origen_datos, true));

    if ($origen_datos["ppc_active"]!="yes"){
        $fields['billing']['nopickup'] = array(
        );
        return $fields;
    }

    $elockers = isset($origen_datos['elockers']) ? $origen_datos['elockers'] : 0;
    //$peso_ppc = isset($_SESSION['peso_productos_ppc']) && is_numeric($_SESSION['peso_productos_ppc']) && $_SESSION['peso_productos_ppc'] > 0 ? (double)$_SESSION['peso_productos_ppc'] : 1;

    // Calcular el peso total del carrito directamente aquí
    $peso_total_carrito = WC()->cart->get_cart_contents_weight();
    // Usar 1 como fallback si el peso es 0 o no válido
    $peso_ppc = ($peso_total_carrito > 0) ? (double) $peso_total_carrito : 1;

   // error_log('Peso total del carrito (bbloomer_display_pickup_locations) para la API: ' . $peso_ppc); // <-- Log para verificar el peso enviado

    //WBS- U3 - PREGUNTAMOS SI VIENE LA DIRECCION

    // obtenemos la direccion del carrito de compras
    $customer = WC()->cart->get_customer();

    // Obtener nombre de la calle y número (Dirección 1)
    $direccion_envio_1 = $customer->get_shipping_address_1();

    $altura_envio = ""; // Inicializamos la variable para la altura

    // Patrón Regex para encontrar la última secuencia de uno o más dígitos
    // \d+   -> Busca uno o más dígitos
    // \D*   -> Busca cero o más caracteres que NO sean dígitos
    // $     -> Ancla la búsqueda al final de la cadena
    // Esto busca la última secuencia de dígitos seguida opcionalmente por no-dígitos al final
    if (preg_match('/(\d+)\D*$/', $direccion_envio_1, $matches)) {
        // Si se encuentra una coincidencia, el número capturado estará en $matches[1]
        $altura_envio = $matches[1];
    }
    // Si el patrón anterior no encuentra un número al final, intenta buscar la primera secuencia de dígitos
    // Esto es útil para formatos como "123 Calle Falsa"
    elseif (preg_match('/^(\d+)/', $direccion_envio_1, $matches)) {
         // Si se encuentra una secuencia de dígitos al principio, úsala
         $altura_envio = $matches[1];
    }
     // Si ninguno de los patrones anteriores funciona, puedes intentar buscar cualquier secuencia de dígitos en la cadena
     // Este es un enfoque más general, pero podría capturar números que no son la altura si la dirección es compleja
    elseif (preg_match('/\d+/', $direccion_envio_1, $matches)) {
        $altura_envio = $matches[0]; // $matches[0] contiene la coincidencia completa (la primera secuencia de dígitos encontrada)
    }

    // Obtener información adicional de la dirección (Piso, Depto, etc. - Dirección 2)
    $direccion_envio_2 = $customer->get_shipping_address_2();

    // Obtener la Ciudad
    $ciudad_envio = $customer->get_shipping_city();

    // Obtener la Provincia/Estado
    $codigo_provincia_envio = $customer->get_shipping_state();

    // Obtener el País
    $codigo_pais_envio = $customer->get_shipping_country();

    $nombre_provincia_envio = $codigo_provincia_envio; // Por defecto, usamos el código

    // Si tenemos un código de país y un código de provincia, buscamos el nombre completo
    if (!empty($codigo_pais_envio) && !empty($codigo_provincia_envio)) {
        // Obtener la lista de estados/provincias para el país
        $estados_pais = WC()->countries->get_states($codigo_pais_envio);

        // Si el código de provincia existe en la lista, obtenemos el nombre completo
        if (isset($estados_pais[$codigo_provincia_envio])) {
            $nombre_provincia_envio = $estados_pais[$codigo_provincia_envio];
        }
    }

    // Obtener el Código Postal
    $codigo_postal_envio = sanitizarCodigoPostal($customer->get_shipping_postcode());

    error_log(
        "   -dir 1: " . $direccion_envio_1 . 
        "   -altura : " . $altura_envio . 
        "   -dir 2: " . $direccion_envio_2 . 
        "   -ciudad: " . $ciudad_envio . 
        "   -provincia: " . $nombre_provincia_envio.
        "   -CP: " . $codigo_postal_envio .
        "   -pais: " . $codigo_pais_envio 
    );

    
    $params = '{
        "ubicacion": {
            "va_prov_codigo": "%",
            "va_con_llc": 1,
            "direccion": "' . $direccion_envio_1. '",
            "codigoPostal": ' . $codigo_postal_envio . ',
            "localidad": "' . $ciudad_envio . '",
            "provincia": "' . $nombre_provincia_envio . '",
            "altura": ' . $altura_envio . ' 
        },
        "pieza": {
            "peso": '.$peso_ppc.',
            "alto": 0,
            "largo": 0,
            "ancho": 0
        },
        "autentificacion": {
            "shipper": "'.$origen_datos['api_user'].'",
            "password": "'.$origen_datos['api_password'].'"
        },
        "elockers" : '.$elockers.'
    }';

    error_log("Params=".$params);
    $url = $origen_datos['endpoint'] . 'puntosDeRetiroSucursales/';
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    $uea_response = curl_exec($ch);

   // error_log('Respuesta cruda de la API (bbloomer_display_pickup_locations): ' . $uea_response); // <-- Nuevo log

    $sucursales = json_decode($uea_response, true);
    //error_log('Respuesta decodificada de la API (bbloomer_display_pickup_locations): ' . print_r($sucursales, true)); // <-- Nuevo log


    curl_close($ch);
    if(isset($sucursales[0]['data'])){
        $sucursales = $sucursales[0]['data'];
        $_SESSION['sucursales_ppc'] = $sucursales; // <-- Asegúrate de que esto siempre guarde la lista correcta
       // error_log('Sucursales guardadas en sesion (bbloomer_display_pickup_locations): ' . print_r($sucursales, true)); // <-- Nuevo log
    }
    else{
        $sucursales = false;
        $_SESSION['sucursales_ppc'] = false; // <-- Guarda false si no hay data
       // error_log('API no devolvio data. Sucursales en sesion = false (bbloomer_display_pickup_locations)'); // <-- Nuevo log
    }
   $arrayRate = array();

   $labelSelect = "";

   if ($origen_datos["listado_ppc"]=="pickup" || !isset($origen_datos["listado_ppc"]) ) {
       $seleccion = "G";
       $labelSelect = "Seleccion el Punto de Retiro";
   }
   elseif ($origen_datos["listado_ppc"]=="sucursales") {
       $seleccion = "S";
       $labelSelect = "Seleccione la Sucursal";
   }
   else {
       $seleccion = "T";
       $labelSelect = "Seleccione la Sucursal o El Punto de Retiro";
   }

   $cant = 0;
    
    $arrayRate[] ="Sin sucursal";

    if($sucursales){
        $_SESSION['sucursales_ppc'] = $sucursales;
             
        for ($k=0; $k < count($sucursales); $k++) {
            $cod = substr($sucursales[$k]['prov_codigo'], 0, 1);

           // error_log("COD=" . $cod);

            if ($sucursales[$k]['codigoPostal'] && ($cod==$seleccion || $seleccion=="T")){
                $cant++;
                $provincia = $sucursales[$k]['provincia'] ? $sucursales[$k]['provincia'] : $sucursales[$k]['municipalidad'];
                $direccion = $provincia . ' - CP: ' . $sucursales[$k]['codigoPostal'] ." ". $sucursales[$k]['direccion'] ;
                $arrayRate[] = $cant . ") " . $direccion ." (".$sucursales[$k]['prov_codigo'].")";
            }
        }
    }

    $fields['billing']['pick_up_locations'] = array(
        'type' => 'select',
        'options' => $arrayRate,
        'label' => __($labelSelect, 'woocommerce'),
        'class' => array('form-row-wide'),
        'clear' => true,
    );
    
    return $fields;

}
//gancho de la funcion para el endpoint de pickup
add_action('woocommerce_after_checkout_form', 'bbloomer_conditionally_hide_show_pickup', 5);
//script para ajax de pickup
function bbloomer_conditionally_hide_show_pickup()
{
        // Pasar los datos de sucursales de PHP a JavaScript
        $sucursales_json = json_encode($_SESSION['sucursales_ppc'] ?? []);
    ?>
   <script type="text/javascript">
       jQuery(document).ready(function(){

                updateTarifaAjax();

                // Obtener los datos de sucursales pasados desde PHP
                const ueaSucursales = <?php echo $sucursales_json; ?>;

                jQuery('select#pick_up_locations').on('change', function(){
                    var selectElement = document.getElementById("pick_up_locations");
                    var selectedIndex = selectElement.selectedIndex;
                    var address = selectElement.options[selectedIndex].text;
                    var value = jQuery(this).val();
                    var punto_r = false;       

                    // Encontramos el botón para realizar el pedido (ajusta el selector si es necesario para tu tema)
                    var placeOrderButton = jQuery('#place_order');
                    let tarifaValida = false; // Bandera para rastrear si la tarifa es válida

                    if(value != 0){
                        punto_r = true;
                        jQuery("#ship-to-different-address-checkbox").prop("disabled", true);

                        // Verificar la tarifa para el PPC seleccionado y mostrar el alert
                        const selectedPPCIndex = value - 1; // Restar 1 porque el value es 1-based y el array es 0-based
                        if (ueaSucursales && ueaSucursales[selectedPPCIndex]) {
                            const tarifa = parseInt(ueaSucursales[selectedPPCIndex].tarifa);
                            if (isNaN(tarifa) || tarifa <= 0) {

                                alert("¡Atención! No hay tarifa de envío disponible para este Punto de Entrega.");
                                // Desactivar el botón de realizar pedido
                                placeOrderButton.prop('disabled', true).addClass('disabled');
                                tarifaValida = false;
                                
                            } else {
                                
                                // La tarifa es válida, activar el botón de realizar pedido
                                placeOrderButton.prop('disabled', false).removeClass('disabled');
                                tarifaValida = true;
                                
                            }
                        } else {
                            
                            // Si no se encontraron datos de sucursal para el valor (no debería pasar si value != 0), desactivar el botón por si acaso
                            alert("Error: No se encontró información de tarifa para la selección.");
                            placeOrderButton.prop('disabled', true).addClass('disabled');
                            tarifaValida = false;
                            
                        }

                    }else{
                        jQuery("#ship-to-different-address-checkbox").prop("disabled", false);
                        // Asumiendo que las opciones de envío estándar estarán disponibles o serán manejadas por WooCommerce
                        placeOrderButton.prop('disabled', false).removeClass('disabled');
                        tarifaValida = true;
                    }
                    jQuery(this).toggleClass('clicked');
                    updateTarifaAjax(value,punto_r,address);
                });      

            });

            function updateTarifaAjax(value = 0, punto_r = false, address = null){

                jQuery.ajax({
                    type: 'POST',
                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                    data: {
                        action: 'my_unique_action',
                        id_ppc: value,
                        punto_r: punto_r,
                        address_ppc: address
                    },
                    success: function(response) {
                        if (response) {
                            jQuery.each(response, function(selector, content) {
                                jQuery(selector).replaceWith(content);
                            });
                        }
                        jQuery('body').trigger('update_checkout');
                    },
                    error: function(xhr, status, error) {
                        console.error("Error en AJAX:", status, error);
                    }
                });
            }
   </script>
   <?php
}
//para ajax de usuarios no registrados
add_action('wp_ajax_nopriv_my_unique_action','so_wp_ajax_function', 10, 2 );
//para ajax de usuarios registrados
add_action('wp_ajax_my_unique_action','so_wp_ajax_function', 10, 2 );
//funcion como controlador para calcular el shipping desde pickup
function so_wp_ajax_function() {

    global $shipping_session;

    if ( ! session_id() ) {
        session_start();
    }

    $_SESSION["id_ppc"] = $_POST['id_ppc'];
    $_SESSION["punto_r"] = $_POST['punto_r'];
    $_SESSION["address_ppc"] = $_POST['address_ppc'];

    if (isset(WC()->session->$shipping_session)) {
        unset(WC()->session->$shipping_session);
    }

    WC()->cart->calculate_shipping();

    // Obtener los fragmentos actualizados
    $fragments = apply_filters('woocommerce_update_order_review_fragments', []);

    wp_send_json($fragments);
}

function clear_wc_shipping_rates_cache() {
    if (WC()->session) {
        WC()->session->set('shipping_for_package_0', null);
    }
    WC()->cart->calculate_totals(); // Forzar el recálculo de los costos
}
add_filter('woocommerce_checkout_update_order_review', 'clear_wc_shipping_rates_cache');



/**
 * Hook para Reemplazar la dirección de envío con los datos del PPC después de crear la orden
 */ 
add_action('woocommerce_checkout_update_order_meta', 'reemplazar_direccion_con_ppc', 10, 1);
function reemplazar_direccion_con_ppc($order_id) {

    if (!$order_id) return;

    // Obtener los datos almacenados en la sesión
    $origen_datos_uea = $_SESSION['origen_datos_uea'];

    // Si está en formato JSON, decodificarlo
    if (is_string($origen_datos_uea)) {
        $origen_datos_uea = json_decode($origen_datos_uea, true);
    }

    // Verificar si la estructura es válida
    if (is_array($origen_datos_uea) && isset($origen_datos_uea[0]['ppc_datos'])) {
        $ppc_datos = $origen_datos_uea[0]['ppc_datos'];

        // Obtener la orden
        $order = wc_get_order($order_id);
        if (!$order) return;

        // Sobrescribir la dirección de envío con los datos del PPC
        $order->set_shipping_address_1($ppc_datos['direccion']);
        $order->set_shipping_state($ppc_datos['provincia'] . " - " . $ppc_datos['locacion']);  // Código de la provincia
        $order->set_shipping_city("Codigo_PPC: (" . $ppc_datos['prov_codigo'] . ")");  // Localidad
        $order->set_shipping_postcode("CP: " . $ppc_datos['codigo_postal']);  // Código Postal

        // Guardar cambios
        $order->save();
    } else {
        error_log("Datos de PPC no encontrados en la sesión.");
    }
}

/**
 * Metodo para Eliminar las letras del Codigo Postal
 */
function sanitizarCodigoPostal($cp) {

    // Asegurarse de que el valor sea una cadena
    $cp = strval($cp);

    // Eliminar espacios en blanco al principio y al final
    $cp = trim($cp);

    // Eliminar caracteres no numéricos
    $cp = preg_replace('/[^0-9]/', '', $cp);

    return $cp;

}


//----------------------------------------------------------------------
//------------- CHECKEO DE NUEVA VERSION DEL PLUGIN --------------------

// Programar el evento de cron al activar el plugin
function activar_verificacion_version_plugin() {
    if (!wp_next_scheduled('verificar_version_plugin_evento')) {
        wp_schedule_event(time(), PLUGIN_CHECK_FREQUENCY, 'verificar_version_plugin_evento');
    }
}
register_activation_hook(__FILE__, 'activar_verificacion_version_plugin');

// Desactivar el evento de cron al desactivar el plugin
function desactivar_verificacion_version_plugin() {
    wp_clear_scheduled_hook('verificar_version_plugin_evento');
}
register_deactivation_hook(__FILE__, 'desactivar_verificacion_version_plugin');



// Función para verificar la versión del plugin
function verificar_version_plugin() {

    // Obtener la última marca de tiempo de verificación
    $last_check = strtotime(get_option('plugin_version_last_check'));

    // Obtener la marca de tiempo actual
    $current_time = current_time('timestamp');

    $check_interval = INTERVALO_CHECKEO_PLUGIN; // intervalo de espera al proximo checkeo de version del plugin

    // Comprueba si la última verificación está disponible y si han pasado el intervalo de espera
    if ($last_check && ($current_time - $last_check) > $check_interval) {

            $last_version = wp_remote_get(URL_INTEGRATE_PLUGIN_VERSION);
            if (is_wp_error($last_version)) {
                return;
            }
            
            // Actualizar la opción con la fecha y hora actuales (checkeo de version del plugin)
            update_option('plugin_version_last_check', current_time('mysql'));

            $version_data = json_decode(wp_remote_retrieve_body($last_version));
            if (!isset($version_data->version)) {
                return; // Salir si no se encuentra la versión en la respuesta
            }

            $version_disponible = $version_data->version;
            $version_actual = PLUGIN_VERSION_ACTUAL; // Obtener la versión actual del plugin

            // Si no existe version anterior le hardcodeamos una version vieja para que muestre el mensaje de actualizacion
            if (is_null($version_actual)) { $version_actual = "1.0.0.0"; }

            // Comparar versiones
            if (version_compare($version_actual, $version_disponible, '<')) {
                // Establecer un transient para mantener el mensaje visible hasta que se actualice el plugin
                set_transient('plugin_update_notice', true, 0); // '0' indica que el transient nunca expira
            } else {
                // Eliminar el transient si la versión está actualizada
                delete_transient('plugin_update_notice');
            }
    }
}

// Función para mostrar el mensaje de actualización
function mostrar_mensaje_actualizacion() {

    $current_domain = $_SERVER['HTTP_HOST'];
    
    $protocol = getProtocol($current_domain);

    $download_url = "{$protocol}{$current_domain}/download/woocommerce"; // URL de descarga del plugin

    add_action('admin_notices', function() use ($download_url) {

        echo '<div class="notice notice-warning" style="display: flex; align-items: center; padding: 15px;">
                <div style="display: flex; flex-direction: column; align-items: center; border: 1px solid #ccc; padding: 10px; border-radius: 5px;">
                    <img src="' . esc_url(plugins_url( 'urbano-argentina/includes/img/urbano_icono_plugin.jpg' )) . '" style="width: 50px; margin-bottom: 5px;"> 
                </div>
                <p style="margin-left: 20px;">
                    Hay una nueva versión del plugin de <b>Urbano Shipping for WooCommerce</b> disponible. 
                    <a href="' . esc_url($download_url) . '">Descárgala aquí</a>.<br>
                    Esta versión puede llegar a realizar cambios en la configuración del plugin.<br>
                    Cualquier duda, consulte a <a href="mailto:integracionsistemas@urbano.com.ar">integracionsistemas@urbano.com.ar</a>.
                </p>
            </div>';

    });

}

// Función para obtener el protocolo
function getProtocol($current_domain) {
    return ($current_domain == "localhost") ? "http://" : "https://";
}


// Función para verificar el transient y mostrar el mensaje si existe
function verificar_mensaje_actualizacion() {
    if (get_transient('plugin_update_notice')) {
        mostrar_mensaje_actualizacion();
    }
} 


// Hook para ejecutar la verificación al cargar el panel de administración
add_action('admin_init', 'verificar_version_plugin');

// Hook para ejecutar la verificación al cargar el panel de administración
add_action('admin_init', 'verificar_mensaje_actualizacion');

// Hook para ejecutar la verificación de la versión del plugin por el cron
add_action('verificar_version_plugin_evento', 'verificar_version_plugin');

// Función para limpiar el transient al desactivar el plugin
function limpiar_transients_plugin() {
    delete_transient('plugin_update_notice');
}

register_deactivation_hook(__FILE__, 'limpiar_transients_plugin');

?>