<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Array of settings
 */
return array(

	// Separador
	'uea_separator' => array(
		'title' => '----------------------------------------------------Configuracion del Plugin de Urbano Express Argentina-----------------------------------------------------', // You can add a title here, e.g., 'Advanced Settings'
		'type'  => 'title',
		'class' => 'wc_options_group',
	),
	
	'enabled'           => array(
		'title'             => __( 'Activar modulo Urbano', 'woocommerce-shipping-uea' ),
		'type'              => 'checkbox',
		'label'             => __( 'Activar este método de envió', 'woocommerce-shipping-uea' ),
		'default'           => 'no'
	),

	/*'debug'             => array(
		'title'             => __( 'Modo Depuración', 'woocommerce-shipping-uea' ),
		'label'             => __( 'Activar modo depuración', 'woocommerce-shipping-uea' ),
		'type'              => 'checkbox',
		'default'           => 'no',
		'desc_tip'    => true,
		'description'     => __( 'Activar el modo de depuración para mostrar información de depuración en la compra/pago y envío.', 'woocommerce-shipping-uea' )
	),*/

	'title'             => array(
		'title'             => __( 'Título', 'woocommerce-shipping-uea' ),
		'type'              => 'text',
		'description'       => __( 'Controla el título que el usuario ve durante el pago.', 'woocommerce-shipping-uea' ),
		'default'           => __( 'Urbano Argentina', 'woocommerce-shipping-uea' ),
		'desc_tip'          => true
	),

	// 'api'               => array(
	// 	'title'             => __( 'Configuración de la API', 'woocommerce-shipping-uea' ),
	// 	'type'              => 'title',
	// 	'description'       => __( '', 'woocommerce-shipping-uea' ),
	// ),

	// Separador
	'api_separator' => array(
		'title' => '-----------------------------------------------------Configuracion de la API de Urbano Express Argentina-----------------------------------------------------', // You can add a title here, e.g., 'Advanced Settings'
		'type'  => 'title',
		'class' => 'wc_options_group',
	),

	'endpoint'      => array(
		'title'             => __( 'Endpoint', 'woocommerce-shipping-uea' ),
		'type'              => 'select',
		'default'           => __( 'Seleccione el entorno de la API.', 'woocommerce-shipping-uea' ),
		'description'       => __( 'Endpoint para el webservice de Urbano Express.', 'woocommerce-shipping-uea' ),
		'placeholder'       => __( '', 'meta-box' ),
		'custom_attributes' => array( 'required' => 'required' ),
        'default'           => 'https://testing-apis.urbano.com.ar/', // Establece la URL de desarrollo como predeterminada
        'options'           => array(
            'https://apis.urbano.com.ar/'       => __( 'Producción - https://apis.urbano.com.ar/', 'woocommerce-shipping-uea' ),
            'https://testing-apis.urbano.com.ar/' => __( 'Desarrollo - https://testing-apis.urbano.com.ar/', 'woocommerce-shipping-uea' ),
        ),
	),

	'api_user'          => array(
		'title'             => __( 'ID Shipper', 'woocommerce-shipping-uea' ),
		'type'              => 'text',
		'description'       => __( 'Numero único de shipper provisto por urbano', 'woocommerce-shipping-uea' ),
		'default'           => __( '', 'woocommerce-shipping-uea' ),
		'placeholder'       => __( '', 'meta-box' ),
		'custom_attributes' => array( 'required' => 'required' )
	),

	'api_password'      => array(
		'title'             => __( 'Password de UA', 'woocommerce-shipping-uea' ),
		'type'              => 'password',
		'description'       => __( 'Password provista por urbano para poder tener acceso a la API', 'woocommerce-shipping-uea' ),
		'default'           => __( '', 'woocommerce-shipping-uea' ),
		'placeholder'       => __( '', 'meta-box' ),
		'custom_attributes' => array( 'required' => 'required' )
	),

	// Separador
	'parameters_separator' => array(
		'title' => '---------------------------------------------------------------------------Parámetros de Envío---------------------------------------------------------------------------', // You can add a title here, e.g., 'Advanced Settings'
		'type'  => 'title',
		'class' => 'wc_options_group',
	),

	'numeracion' => array(
		'title'             => __( 'Numeracion', 'woocommerce-shipping-uea' ),
		'type'              => 'number',
		'default'           => '',
		'description'       => __( 'Ingrese un prefijo de 1 digito para el numero de seguimiento, de lo contrario deberá quedar vacío.', 'woocommerce-shipping-uea' ),
		'placeholder'       => '',
		'custom_attributes' => array(
			'min'  => '0',
			'max'  => '9',
			'step' => '1'
		)
	),

	'envio_gratis'      => array(
		'title'             => __( 'No cobrar el costo de envío', 'woocommerce-shipping-uea' ),
		'label'             => __( 'No agregar el costo de envío en el Total (carrito/checkout).', 'woocommerce-shipping-uea' ),
		'type'              => 'checkbox',
		'default'           => 'no',
		'desc_tip'          => true,
		'description'       => __( 'Al activar este modulo, no se agregara el costo de envío en el Total (carrito/checkout).', 'woocommerce-shipping-uea' )
	),

	'costo_fijo'      => array(
		'title'             => __( 'Costo fijo de envío', 'woocommerce-shipping-uea' ),
		'type'              => 'text',
		'default'           => __( '', 'woocommerce-shipping-uea' ),
		'placeholder'       => __( '', 'meta-box' ),
		'description'       => __( 'Al activar este modulo, Se asignara costo de envío fijo en el Total (carrito/checkout). <br/>De lo contrario debera especificar 0 o ningun valor', 'woocommerce-shipping-uea' )
	),

	'limite_envio_gratis' => array(
		'title'             => __( 'Límite de envío gratuito', 'woocommerce-shipping-uea' ),
		'type'              => 'number',
		'default'           => '0',
		'placeholder'       => '0',
		'description'       => __( 'Ingrese el monto mínimo de compra para que el envío sea gratuito. <br/> Para deshabilitarlo setear el limite en 0 (cero).', 'woocommerce-shipping-uea' ),
		'custom_attributes' => array(
			'min'  => '0',
			'step' => '1'
		)
	),

	'declarado'      => array(
		'title'             => __( 'Valor declarado - Seguro (%)', 'woocommerce-shipping-uea' ),
		'type'              => 'number',
		'default'           => __( '0', 'woocommerce-shipping-uea' ),
		'placeholder'       => __( '', 'meta-box' ),
		'description'       => __( 'Al activar este modulo, Ingrese un porcentaje para calcular el valor declarado.<br/> De lo contrario debera especificar 0 o ningun valor Maximo 100', 'woocommerce-shipping-uea' ),
		'custom_attributes' => array(
			'min'  => '0',
			'max'  => '100',
			'step' => '1'
		)
	),

	'contrareembolso'      => array(
		'title'             => __( 'Agregar contra reembolso', 'woocommerce-shipping-uea' ),
		'label'             => __( 'Esta opcion se agregara en el (carrito/checkout).', 'woocommerce-shipping-uea' ),
		'type'              => 'checkbox',
		'default'           => 'no',
		'desc_tip'          => false,
		'description'       => __( 'Contra reembolso en el Total (carrito/checkout).', 'woocommerce-shipping-uea' )
	),

	'porcentaje_iva'      => array(
		'title'             => __( 'Añadir porcentaje al costo de envío (%)', 'woocommerce-shipping-uea' ),
		'type'              => 'number',
		'default'           => __( '1', 'woocommerce-shipping-uea' ),
		'description'       => __( 'Al ser cero o nulo no se adicionara ninguno porcentaje', 'woocommerce-shipping-uea' ),
		'placeholder'       => __( '0', 'meta-box' ),
		'custom_attributes' => array(
			'min'  => '0',
			'step' => '1'
		)
	), 

	'redondear_total'   => array(
		'title'             => __( 'Ajustar Totales', 'woocommerce-shipping-uea' ),
		'label'             => __( 'Mostrar costos totales sin decimales. Ej: $56.96 a $57', 'woocommerce-shipping-uea' ),
		'type'              => 'checkbox',
		'default'           => 'no',
		'desc_tip'          => true,
		'description'       => __( 'Mostrar costos totales sin decimales. Ej: $56.96 a $57', 'woocommerce-shipping-uea' )
	),

	'auto_impacto'      => array(
		'title'             => __( 'Solicitar envió automáticamente', 'woocommerce-shipping-uea' ),
		'label'             => __( 'Solicitar a Urbano el envió al momento que realiza el Checkout', 'woocommerce-shipping-uea' ),
		'type'              => 'select',
		'default'           => 'no',
		'desc_tip'          => true,
		'description'       => __( 'Cuando esté seleccionado la solicitud de envio a Urbano se realizara de forma automática en el checkout, en caso de no estarlo el envió deberá ser enviado manualmente desde el panel de pedidos', 'woocommerce-shipping-uea' ),
		'options'           => array(
	        'no' => __('No', 'woocommerce' ),
	        'si' => __('Si, en cualquier estado', 'woocommerce' ),
	        'pagado' => __('Cuando este pagado en el checkout', 'woocommerce' )
    	),
    ),

	'modo_envio'      => array(
		'title'             => __( 'Modo de envio del servicio', 'woocommerce-shipping-uea' ),
		'label'             => __( 'Ware Housing / Cross Docking', 'woocommerce-shipping-uea' ),
		'type'              => 'select',
		'default'           => 'cross',
		'desc_tip'          => true,
		'description'       => __( 'Envios en Ware o Cross', 'woocommerce-shipping-uea' ),
		'options'           => array(
	        'cross' => __('Cross Docking', 'woocommerce' ),
	        'ware' => __('Ware Housing', 'woocommerce' )
		),
	),

	// Separador
	'ppc_separator' => array(
		'title' => '------------------------------------------------------------------------Envíos por PPC o Sucursales----------------------------------------------------------------------', // You can add a title here, e.g., 'Advanced Settings'
		'type'  => 'title',
		'class' => 'wc_options_group',
	),


	'ppc_active'      => array(
		'title'             => __( 'Activar puntos de retiro', 'woocommerce-shipping-uea' ),
		'label'             => __( 'Esta opcion permitira activar/desactivar los puntos de retiro.', 'woocommerce-shipping-uea' ),
		'type'              => 'checkbox',
		'default'           => 'no',
		'desc_tip'          => false,
		'description'       => __( 'Sucursales de retiro.', 'woocommerce-shipping-uea' )
	),

	'listado_ppc'      => array(
		'title'             => __( 'Modo de listado pickup/sucursales', 'woocommerce-shipping-uea' ),
		'label'             => __( 'Pickup point / Sucursales', 'woocommerce-shipping-uea' ),
		'type'              => 'select',
		'default'           => 'pickup',
		'desc_tip'          => true,
		'description'       => __( 'Seleccione el modo de pickup', 'woocommerce-shipping-uea' ),
		'options'           => array(
	        'pickup' => __('Pickup Point', 'woocommerce' ),
	        'sucursales' => __('Sucursales', 'woocommerce' ),
	        'todos' => __('Todos', 'woocommerce' )
		),
	),

	'elockers'      => array(
		'title'             => __( 'E-Locker', 'woocommerce-shipping-uea' ),
		'label'             => __( 'Modalidad de Elocker en la API de PPC', 'woocommerce-shipping-uea' ),
		'type'              => 'select',
		'default'           => '0',
		'desc_tip'          => true,
		'description'       => __( 'Seleccione el modo del parametro E-Locker', 'woocommerce-shipping-uea' ),
		'options'           => array(
	        '0' => __('0', 'woocommerce' ),
	        '1' => __('1', 'woocommerce' )
		),
	),

);